/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse.swf;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.readers.SWFReader;
import com.anotherbigidea.flash.readers.TagParser;
import com.anotherbigidea.io.InStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.parse.Outlink;
import org.apache.nutch.parse.OutlinkExtractor;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.parse.ParseImpl;
import org.apache.nutch.parse.ParseResult;
import org.apache.nutch.parse.ParseStatus;
import org.apache.nutch.parse.Parser;
import org.apache.nutch.parse.swf.ExtractText;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.util.NutchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SWFParser
implements Parser {
    public static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.nutch.parse.swf");
    private Configuration conf = null;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public ParseResult getParse(Content content) {
        String text = null;
        Vector<Outlink> outlinks = new Vector<Outlink>();
        try {
            byte[] raw = content.getContent();
            String contentLength = content.getMetadata().get("Content-Length");
            if (contentLength != null && raw.length != Integer.parseInt(contentLength)) {
                return new ParseStatus(2, 202, "Content truncated at " + raw.length + " bytes. Parser can't handle incomplete files.").getEmptyParseResult(content.getUrl(), this.getConf());
            }
            ExtractText extractor = new ExtractText();
            TagParser parser = new TagParser((SWFTagTypes)extractor);
            SWFReader reader = new SWFReader((SWFTags)parser, new InStream(raw));
            reader.readFile();
            text = extractor.getText();
            String atext = extractor.getActionText();
            if (atext != null && atext.length() > 0) {
                text = text + "\n--------\n" + atext;
            }
            String[] links = extractor.getUrls();
            for (int i = 0; i < links.length; ++i) {
                Outlink out = new Outlink(links[i], "");
                outlinks.add(out);
            }
            Outlink[] olinks = OutlinkExtractor.getOutlinks((String)text, (Configuration)this.conf);
            if (olinks != null) {
                for (int i = 0; i < olinks.length; ++i) {
                    outlinks.add(olinks[i]);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error, runtime exception: ", (Throwable)e);
            return new ParseStatus(2, "Can't be handled as SWF document. " + e).getEmptyParseResult(content.getUrl(), this.getConf());
        }
        if (text == null) {
            text = "";
        }
        Outlink[] links = outlinks.toArray(new Outlink[outlinks.size()]);
        ParseData parseData = new ParseData(ParseStatus.STATUS_SUCCESS, "", links, content.getMetadata());
        return ParseResult.createParseResult((String)content.getUrl(), (Parse)new ParseImpl(text, parseData));
    }

    public static void main(String[] args) throws IOException {
        FileInputStream in = new FileInputStream(args[0]);
        byte[] buf = new byte[in.available()];
        in.read(buf);
        in.close();
        SWFParser parser = new SWFParser();
        ParseResult parseResult = parser.getParse(new Content("file:" + args[0], "file:" + args[0], buf, "application/x-shockwave-flash", new Metadata(), NutchConfiguration.create()));
        Parse p = parseResult.get("file:" + args[0]);
        System.out.println("Parse Text:");
        System.out.println(p.getText());
        System.out.println("Parse Data:");
        System.out.println(p.getData());
    }
}

