/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.settings.KeyChangeEvent;
import org.archive.settings.KeyChangeListener;
import org.archive.settings.SheetManager;
import org.archive.settings.SingleSheet;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Path;
import org.archive.state.StateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanShellProcessor
extends Processor
implements Initializable,
KeyChangeListener {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(BeanShellProcessor.class.getName());
    @Immutable
    public static final Key<Path> SCRIPT_FILE = Key.make((Path)Path.EMPTY);
    @Immutable
    public static final Key<Boolean> ISOLATE_THREADS = Key.make((boolean)true);
    @Immutable
    public static final Key<SheetManager> MANAGER = Key.makeAuto(SheetManager.class);
    protected ThreadLocal<Interpreter> threadInterpreter;
    protected Interpreter sharedInterpreter;
    public Map<Object, Object> sharedMap = Collections.synchronizedMap(new HashMap());
    private SheetManager manager;

    @Override
    protected boolean shouldProcess(ProcessorURI curi) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void innerProcess(ProcessorURI curi) {
        Interpreter interpreter;
        Interpreter interpreter2 = interpreter = this.getInterpreter();
        synchronized (interpreter2) {
            try {
                interpreter.set("curi", (Object)curi);
                interpreter.eval("process(curi)");
            }
            catch (EvalError e) {
                logger.log(Level.WARNING, "BeanShell error", e);
            }
        }
    }

    protected Interpreter getInterpreter() {
        if (this.sharedInterpreter != null) {
            return this.sharedInterpreter;
        }
        Interpreter interpreter = this.threadInterpreter.get();
        if (interpreter == null) {
            interpreter = this.newInterpreter();
            this.threadInterpreter.set(interpreter);
        }
        return interpreter;
    }

    protected Interpreter newInterpreter() {
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.set("self", (Object)this);
            interpreter.set("manager", (Object)this.manager);
            File file = this.get(SCRIPT_FILE).toFile();
            try {
                interpreter.source(file.getPath());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "unable to read script file", e);
            }
        }
        catch (EvalError e) {
            logger.log(Level.SEVERE, "error in source file", e);
        }
        return interpreter;
    }

    public void initialTasks(StateProvider context) {
        this.manager = (SheetManager)context.get((Object)this, MANAGER);
        this.isolate((Boolean)context.get((Object)this, ISOLATE_THREADS));
    }

    public void keyChanged(KeyChangeEvent event) {
        if (event.getKey() == ISOLATE_THREADS) {
            this.isolate((Boolean)event.getNewValue());
        }
    }

    private void isolate(boolean isolate) {
        if (isolate) {
            this.sharedInterpreter = null;
            this.threadInterpreter = new ThreadLocal();
        } else {
            this.sharedInterpreter = this.newInterpreter();
            this.threadInterpreter = null;
        }
    }

    private <T> T get(Key<T> key) {
        SingleSheet def = this.manager.getGlobalSheet();
        return (T)def.get((Object)this, key);
    }

    static {
        KeyManager.addKeys(BeanShellProcessor.class);
    }
}

