/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.ProcessorURI;
import org.archive.modules.credential.CredentialAvatar;
import org.archive.modules.extractor.Link;
import org.archive.modules.extractor.LinkContext;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.RobotsHonoringPolicy;
import org.archive.net.UURI;
import org.archive.state.ExampleStateProvider;
import org.archive.util.Recorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProcessorURI
extends ExampleStateProvider
implements ProcessorURI {
    private final Collection<String> annotations = new ArrayList<String>();
    private final Set<CredentialAvatar> avatars = new HashSet<CredentialAvatar>();
    private final List<Throwable> nonFatalFailures = new ArrayList<Throwable>();
    private final List<Link> outLinks = new ArrayList<Link>();
    private final List<ExceptionHolder> uriErrors = new ArrayList<ExceptionHolder>();
    private int discardedOutLinks;
    private String from;
    private String userAgent;
    private long length;
    private long size;
    private String contentType;
    private long startTime;
    private long endTime;
    private int fetchStatus;
    private ProcessorURI.FetchType fetchType = ProcessorURI.FetchType.UNKNOWN;
    private HttpMethod httpMethod;
    private String pathFromSeed;
    private UURI base;
    private Map<String, Object> data = new HashMap<String, Object>();
    private Recorder recorder;
    private String resolvedName;
    private RobotsHonoringPolicy robotsHonoringPolicy;
    private UURI uuri;
    private UURI via;
    private LinkContext viaContext;
    private boolean linkExtractionFinished;
    private boolean location;
    private boolean prereq;
    private boolean seed;
    private boolean forceFetch;

    public DefaultProcessorURI(UURI uuri, LinkContext context) {
        this.uuri = uuri;
        this.viaContext = context;
    }

    public void addUriError(URIException e, String uri) {
        this.uriErrors.add(new ExceptionHolder(e, uri));
    }

    public List<ExceptionHolder> getUriErrors() {
        return this.uriErrors;
    }

    public boolean attachRfc2617Credential(String realm) {
        return false;
    }

    public boolean detachRfc2617Credential(String realm) {
        return false;
    }

    @Override
    public Collection<String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public UURI getBaseURI() {
        return this.base;
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    public void setContentLength(long len) {
        this.length = len;
    }

    @Override
    public long getContentSize() {
        return this.size;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public CrawlHost getCrawlHost() {
        return null;
    }

    public CrawlServer getCrawlServer(String serverKey) {
        return null;
    }

    @Override
    public boolean hasCredentialAvatars() {
        return this.getCredentialAvatars().size() > 0;
    }

    @Override
    public Set<CredentialAvatar> getCredentialAvatars() {
        return this.avatars;
    }

    @Override
    public String getDNSServerIPLabel() {
        return null;
    }

    @Override
    public Map<String, Object> getData() {
        return this.data;
    }

    @Override
    public long getFetchBeginTime() {
        return this.startTime;
    }

    @Override
    public long getFetchCompletedTime() {
        return this.endTime;
    }

    @Override
    public int getFetchStatus() {
        return this.fetchStatus;
    }

    @Override
    public ProcessorURI.FetchType getFetchType() {
        return this.fetchType;
    }

    public String getFrom() {
        return this.from;
    }

    @Override
    public Collection<Throwable> getNonFatalFailures() {
        return this.nonFatalFailures;
    }

    public List<Link> getOutLinks() {
        return this.outLinks;
    }

    @Override
    public String getPathFromSeed() {
        return this.pathFromSeed;
    }

    @Override
    public Recorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(Recorder r) {
        this.recorder = r;
    }

    public String getResolvedName() {
        return this.resolvedName;
    }

    public RobotsHonoringPolicy getRobotsHonoringPolicy() {
        return this.robotsHonoringPolicy;
    }

    @Override
    public UURI getUURI() {
        return this.uuri;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public void setUserAgent(String ua) {
        this.userAgent = ua;
    }

    @Override
    public UURI getVia() {
        return this.via;
    }

    @Override
    public LinkContext getViaContext() {
        return this.viaContext;
    }

    @Override
    public boolean hasBeenLinkExtracted() {
        return this.linkExtractionFinished;
    }

    @Override
    public boolean isLocation() {
        return this.location;
    }

    @Override
    public boolean isPrerequisite() {
        return this.prereq;
    }

    @Override
    public boolean isSeed() {
        return this.seed;
    }

    public boolean passedDNS() {
        return false;
    }

    public boolean populateCredentials(HttpMethod method) {
        return false;
    }

    public void promoteCredentials() {
    }

    public void requestCrawlPause() {
    }

    @Override
    public void setBaseURI(UURI base) {
        this.base = base;
    }

    @Override
    public void setContentDigest(String algorithm, byte[] digest) {
    }

    @Override
    public void setContentSize(long size) {
        this.size = size;
    }

    @Override
    public void setContentType(String mimeType) {
        this.contentType = mimeType;
    }

    @Override
    public void setDNSServerIPLabel(String label) {
    }

    @Override
    public void setError(String msg) {
    }

    @Override
    public void setFetchBeginTime(long time) {
        this.startTime = time;
    }

    @Override
    public void setFetchCompletedTime(long time) {
        this.endTime = time;
    }

    @Override
    public void setFetchStatus(int status) {
        this.fetchStatus = status;
    }

    @Override
    public void setFetchType(ProcessorURI.FetchType type) {
        if (type == null) {
            throw new IllegalArgumentException("fetchType is non-null");
        }
        this.fetchType = type;
    }

    @Override
    public void setHttpMethod(HttpMethod method) {
        this.httpMethod = method;
    }

    @Override
    public void linkExtractorFinished() {
        this.linkExtractionFinished = true;
    }

    @Override
    public void setPrerequisite(boolean prereq) {
        this.prereq = prereq;
    }

    @Override
    public void setSeed(boolean seed) {
        this.seed = seed;
    }

    public void skipToPostProcessing() {
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public int getFetchAttempts() {
        return 1;
    }

    @Override
    public boolean containsDataKey(String k) {
        return this.data.containsKey(k);
    }

    @Override
    public byte[] getContentDigest() {
        return null;
    }

    @Override
    public String getContentDigestSchemeString() {
        return null;
    }

    @Override
    public void makeHeritable(String attr) {
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public Map<String, Object> getPersistentDataMap() {
        return null;
    }

    @Override
    public void addPersistentDataMapKey(String s) {
    }

    @Override
    public void incrementDiscardedOutLinks() {
        ++this.discardedOutLinks;
    }

    @Override
    public boolean forceFetch() {
        return this.forceFetch;
    }

    public void setForceFetch(boolean b) {
        this.forceFetch = b;
    }

    @Override
    public String getSourceTag() {
        return "";
    }

    public static class ExceptionHolder {
        public final Throwable exception;
        public final String description;

        public ExceptionHolder(Throwable e, String desc) {
            this.exception = e;
            this.description = desc;
        }
    }
}

