/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.archive.modules.ProcessResult;
import org.archive.modules.ProcessorURI;
import org.archive.modules.credential.CredentialAvatar;
import org.archive.modules.credential.Rfc2617Credential;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRuleSequence;
import org.archive.net.UURI;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Module;

public abstract class Processor
implements Module,
Serializable {
    public static final Key<Boolean> ENABLED = Key.make((boolean)Boolean.TRUE);
    public static final Key<DecideRuleSequence> DECIDE_RULES = Key.make(DecideRuleSequence.class, DecideRuleSequence.class);
    private AtomicLong uriCount = new AtomicLong(0L);

    public ProcessResult process(ProcessorURI uri) throws InterruptedException {
        if (!((Boolean)uri.get(this, ENABLED)).booleanValue()) {
            return ProcessResult.PROCEED;
        }
        if (((DecideRuleSequence)uri.get(this, DECIDE_RULES)).decisionFor(uri) == DecideResult.REJECT) {
            this.innerRejectProcess(uri);
            return ProcessResult.PROCEED;
        }
        if (this.shouldProcess(uri)) {
            this.uriCount.incrementAndGet();
            return this.innerProcessResult(uri);
        }
        return ProcessResult.PROCEED;
    }

    public long getURICount() {
        return this.uriCount.get();
    }

    protected abstract boolean shouldProcess(ProcessorURI var1);

    protected ProcessResult innerProcessResult(ProcessorURI uri) throws InterruptedException {
        this.innerProcess(uri);
        return ProcessResult.PROCEED;
    }

    protected abstract void innerProcess(ProcessorURI var1) throws InterruptedException;

    protected void innerRejectProcess(ProcessorURI uri) throws InterruptedException {
    }

    public static String flattenVia(ProcessorURI puri) {
        UURI uuri = puri.getVia();
        return uuri == null ? "" : uuri.toString();
    }

    public static boolean isSuccess(ProcessorURI puri) {
        boolean result = false;
        int statusCode = puri.getFetchStatus();
        result = statusCode == 401 && Processor.hasRfc2617CredentialAvatar(puri) ? false : statusCode > 0;
        return result;
    }

    public static long getRecordedSize(ProcessorURI puri) {
        if (puri.getRecorder() == null) {
            return puri.getContentSize();
        }
        return puri.getRecorder().getRecordedInput().getSize();
    }

    public static boolean hasRfc2617CredentialAvatar(ProcessorURI puri) {
        Set<CredentialAvatar> avatars = puri.getCredentialAvatars();
        for (CredentialAvatar ca : avatars) {
            if (!ca.match(Rfc2617Credential.class)) continue;
            return true;
        }
        return false;
    }

    public String report() {
        return "";
    }

    static {
        KeyManager.addKeys(Processor.class);
    }
}

