/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.canonicalize;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.modules.canonicalize.CanonicalizationRule;
import org.archive.state.StateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Canonicalizer {
    private static Logger logger = Logger.getLogger(Canonicalizer.class.getName());

    private Canonicalizer() {
    }

    public static String canonicalize(StateProvider context, String uri, Iterable<CanonicalizationRule> rules) {
        return Canonicalizer.canonicalize(context, uri, rules.iterator());
    }

    public static String canonicalize(StateProvider context, String uri, Iterator<CanonicalizationRule> rules) {
        String before;
        String canonical = before = uri;
        while (rules.hasNext()) {
            CanonicalizationRule r = rules.next();
            if (!r.isEnabled(context)) {
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer("Rule " + r.getClass().getName() + " is disabled.");
                continue;
            }
            canonical = r.canonicalize(canonical, context);
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer("Rule " + r.getClass().getName() + " " + before + " => " + canonical);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.fine(before + " => " + canonical);
        }
        return canonical;
    }
}

