/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.canonicalize;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.archive.modules.canonicalize.BaseRule;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;

public class RegexRule
extends BaseRule {
    private static final long serialVersionUID = -3L;
    protected static Logger logger = Logger.getLogger(BaseRule.class.getName());
    public static final Key<Pattern> REGEX = Key.make((Pattern)Pattern.compile("(.*)"));
    public static final Key<String> FORMAT = Key.make((String)"${1}");

    public String canonicalize(String url, StateProvider context) {
        Pattern pattern = (Pattern)context.get((Object)this, REGEX);
        Matcher matcher = pattern.matcher(url);
        if (!matcher.matches()) {
            return url;
        }
        String format = (String)context.get((Object)this, FORMAT);
        StringBuffer buffer = new StringBuffer(url.length() * 2);
        this.format(matcher, format, buffer);
        return buffer.toString();
    }

    protected void format(Matcher matcher, String format, StringBuffer buffer) {
        block6: for (int i = 0; i < format.length(); ++i) {
            switch (format.charAt(i)) {
                case '\\': {
                    if (i + 1 < format.length() && format.charAt(i + 1) == '$') continue block6;
                }
                case '$': {
                    if (i == 0 || i > 0 && format.charAt(i - 1) != '\\') {
                        int groupIndex;
                        int j;
                        int start = i + 1;
                        boolean curlyBraceStart = false;
                        if (format.charAt(start) == '{') {
                            curlyBraceStart = true;
                        }
                        for (j = ++start; j < format.length() && Character.isDigit(format.charAt(j)); ++j) {
                        }
                        if (j > start && (groupIndex = Integer.parseInt(format.substring(start, j))) >= 0 && groupIndex < 256) {
                            String g = null;
                            try {
                                g = matcher.group(groupIndex);
                            }
                            catch (IndexOutOfBoundsException e) {
                                logger.warning("IndexOutOfBoundsException getting group " + groupIndex + " from " + matcher.group(0) + " with format of " + format);
                            }
                            if (g != null) {
                                buffer.append(g);
                            }
                            if (curlyBraceStart && format.charAt(j) == '}') {
                                ++j;
                            }
                            i = j - 1;
                            continue block6;
                        }
                    }
                }
                default: {
                    buffer.append(format.charAt(i));
                }
            }
        }
    }

    static {
        KeyManager.addKeys(RegexRule.class);
    }
}

