/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.canonicalize;

import java.util.regex.Pattern;
import org.archive.modules.canonicalize.BaseRule;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;

public class StripSessionCFIDs
extends BaseRule {
    private static final long serialVersionUID = 3L;
    private static final String REGEX = "^(.+)(?:cfid=[^&]+&cftoken=[^&]+(?:jsession=[^&]+)?)(?:&(.*))?$";
    private static final Pattern COLDFUSION_PATTERN = Pattern.compile("^(.+)(?:cfid=[^&]+&cftoken=[^&]+(?:jsession=[^&]+)?)(?:&(.*))?$", 2);

    public String canonicalize(String url, StateProvider context) {
        return this.doStripRegexMatch(url, COLDFUSION_PATTERN.matcher(url));
    }

    static {
        KeyManager.addKeys(StripSessionCFIDs.class);
    }
}

