/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.canonicalize;

import java.util.regex.Pattern;
import org.archive.modules.canonicalize.BaseRule;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;

public class StripSessionIDs
extends BaseRule {
    private static final long serialVersionUID = 3L;
    private static final Pattern BASE_PATTERN = Pattern.compile("^(.+)(?:(?:(?:jsessionid)|(?:phpsessid))=[0-9a-zA-Z]{32})(?:&(.*))?$", 2);
    private static final Pattern SID_PATTERN = Pattern.compile("^(.+)(?:sid=[0-9a-zA-Z]{32})(?:&(.*))?$", 2);
    private static final Pattern ASPSESSION_PATTERN = Pattern.compile("^(.+)(?:ASPSESSIONID[a-zA-Z]{8}=[a-zA-Z]{24})(?:&(.*))?$", 2);

    public String canonicalize(String url, StateProvider context) {
        url = this.doStripRegexMatch(url, BASE_PATTERN.matcher(url));
        url = this.doStripRegexMatch(url, SID_PATTERN.matcher(url));
        url = this.doStripRegexMatch(url, ASPSESSION_PATTERN.matcher(url));
        return url;
    }

    static {
        KeyManager.addKeys(StripSessionIDs.class);
    }
}

