/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.credential;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.archive.modules.ProcessorURI;
import org.archive.modules.credential.CredentialAvatar;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.ServerCache;
import org.archive.modules.net.ServerCacheUtil;
import org.archive.state.Expert;
import org.archive.state.Global;
import org.archive.state.Key;
import org.archive.state.Module;

public abstract class Credential
implements Module,
Serializable {
    private static final Logger logger = Logger.getLogger(Credential.class.getName());
    @Global
    @Expert
    public static final Key<String> CREDENTIAL_DOMAIN = Key.make((String)"");

    public String getCredentialDomain(ProcessorURI context) {
        return (String)context.get(this, CREDENTIAL_DOMAIN);
    }

    public void attach(ProcessorURI curi) {
        this.attach(curi, null);
    }

    public void attach(ProcessorURI curi, String payload) {
        CredentialAvatar ca = payload == null ? new CredentialAvatar(this.getClass(), this.getKey(curi)) : new CredentialAvatar(this.getClass(), this.getKey(curi), payload);
        curi.getCredentialAvatars().add(ca);
    }

    public boolean detach(ProcessorURI curi) {
        boolean result = false;
        Set<CredentialAvatar> avatars = curi.getCredentialAvatars();
        if (avatars.isEmpty()) {
            logger.severe("This curi " + curi + " has no cred when it should");
        }
        Iterator<CredentialAvatar> iter = avatars.iterator();
        while (iter.hasNext()) {
            CredentialAvatar ca = iter.next();
            if (!ca.match(this.getClass(), this.getKey(curi))) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    public boolean detachAll(ProcessorURI curi) {
        boolean result = false;
        Set<CredentialAvatar> avatars = curi.getCredentialAvatars();
        if (avatars.isEmpty()) {
            logger.severe("This curi " + curi + " has no creds when it should.");
            return false;
        }
        Iterator<CredentialAvatar> iter = avatars.iterator();
        while (iter.hasNext()) {
            CredentialAvatar ca = iter.next();
            if (!ca.match(this.getClass())) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    public abstract boolean isPrerequisite(ProcessorURI var1);

    public abstract boolean hasPrerequisite(ProcessorURI var1);

    public abstract String getPrerequisite(ProcessorURI var1);

    public abstract String getKey(ProcessorURI var1);

    public abstract boolean isEveryTime();

    public abstract boolean populate(ProcessorURI var1, HttpClient var2, HttpMethod var3, String var4);

    public abstract boolean isPost(ProcessorURI var1);

    public boolean rootUriMatch(ServerCache cache, ProcessorURI curi) {
        String cd = this.getCredentialDomain(curi);
        CrawlServer serv = ServerCacheUtil.getServerFor(cache, curi.getUURI());
        String serverName = serv.getName();
        logger.fine("RootURI: Comparing " + serverName + " " + cd);
        return cd != null && serverName != null && serverName.equalsIgnoreCase(cd);
    }
}

