/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.credential;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.archive.modules.ProcessorURI;
import org.archive.modules.credential.Credential;
import org.archive.modules.credential.CredentialStore;

public class CredentialAvatar
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(CredentialAvatar.class.getName());
    private final String key;
    private final Class type;
    private final String payload;

    public CredentialAvatar(Class type, String key) {
        this(type, key, null);
    }

    public CredentialAvatar(Class type, String key, String payload) {
        if (!this.checkType(type)) {
            throw new IllegalArgumentException("Type is unrecognized: " + type);
        }
        this.key = key;
        this.type = type;
        this.payload = payload;
    }

    private CredentialAvatar() {
        this.key = null;
        this.type = null;
        this.payload = null;
    }

    protected boolean checkType(Class candidateType) {
        boolean result = false;
        List<Class> types = CredentialStore.getCredentialTypes();
        Iterator<Class> i = types.iterator();
        while (i.hasNext()) {
            if (!i.next().equals(candidateType)) continue;
            result = true;
            break;
        }
        return result;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getKey() {
        return this.key;
    }

    public Class getType() {
        return this.type;
    }

    public boolean match(Class otherType) {
        return this.type.equals(otherType);
    }

    public boolean match(Class otherType, String otherKey) {
        return this.match(otherType) && otherKey != null && this.key != null && this.key.equals(otherKey);
    }

    public String toString() {
        return this.getType() + "." + this.getKey();
    }

    public Credential getCredential(CredentialStore cs, ProcessorURI curi) {
        Credential result = null;
        if (cs == null) {
            logger.severe("No credential store for " + curi);
            return result;
        }
        Collection<Credential> all = cs.getAll(curi);
        if (all == null) {
            logger.severe("Have CredentialAvatar " + this.toString() + " but no collection: " + curi);
            return result;
        }
        for (Credential c : all) {
            String credKey;
            if (!this.type.isInstance(c) || (credKey = c.getKey(curi)) == null || !credKey.equals(this.getKey())) continue;
            result = c;
            break;
        }
        if (result == null) {
            logger.severe("Have CredentialAvatar " + this.toString() + " but no corresponding credential: " + curi);
        }
        return result;
    }
}

