/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.credential;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.archive.modules.ProcessorURI;
import org.archive.modules.credential.Credential;
import org.archive.modules.credential.CredentialAvatar;
import org.archive.modules.credential.HtmlFormCredential;
import org.archive.modules.credential.Rfc2617Credential;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Module;
import org.archive.state.StateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CredentialStore
implements Module,
Serializable {
    private static final long serialVersionUID = 3L;
    private static Logger logger = Logger.getLogger("org.archive.crawler.datamodel.CredentialStore");
    public static final Key<Map<String, Credential>> CREDENTIALS = Key.makeMap(Credential.class);
    private static final List<Class> credentialTypes;

    public static List<Class> getCredentialTypes() {
        return credentialTypes;
    }

    public Collection<Credential> getAll(StateProvider context) {
        Map map = (Map)context.get((Object)this, CREDENTIALS);
        return map.values();
    }

    public Credential get(StateProvider context, String name) {
        return (Credential)((Map)context.get((Object)this, CREDENTIALS)).get(name);
    }

    public Set subset(ProcessorURI context, Class type) {
        return this.subset(context, type, null);
    }

    public Set<Credential> subset(ProcessorURI context, Class type, String rootUri) {
        HashSet<Credential> result = null;
        for (Credential c : this.getAll(context)) {
            String cd;
            if (!type.isInstance(c) || rootUri != null && ((cd = c.getCredentialDomain(context)) == null || !rootUri.equalsIgnoreCase(cd))) continue;
            if (result == null) {
                result = new HashSet<Credential>();
            }
            result.add(c);
        }
        return result;
    }

    public Credential getCredential(ProcessorURI curi, CredentialAvatar ca) {
        Credential result = null;
        Collection<Credential> all = this.getAll(curi);
        if (all == null) {
            logger.severe("Have CredentialAvatar " + this.toString() + " but no collection: " + curi);
            return result;
        }
        for (Credential c : all) {
            String credKey;
            if (!ca.getType().isInstance(c) || (credKey = c.getKey(curi)) == null || !credKey.equals(ca.getKey())) continue;
            result = c;
            break;
        }
        if (result == null) {
            logger.severe("Have CredentialAvatar " + this.toString() + " but no corresponding credential: " + curi);
        }
        return result;
    }

    static {
        Class[] tmp = new Class[]{HtmlFormCredential.class, Rfc2617Credential.class};
        credentialTypes = Collections.unmodifiableList(Arrays.asList(tmp));
        KeyManager.addKeys(CredentialStore.class);
    }
}

