/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.credential;

import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.archive.modules.ProcessorURI;
import org.archive.modules.credential.Credential;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.state.Expert;
import org.archive.state.Global;
import org.archive.state.Key;
import org.archive.state.KeyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlFormCredential
extends Credential {
    private static final long serialVersionUID = -3L;
    private static final Logger logger = Logger.getLogger(HtmlFormCredential.class.getName());
    @Global
    @Expert
    public static final Key<String> LOGIN_URI = Key.make((String)"");
    @Global
    @Expert
    public static final Key<Map<String, String>> FORM_ITEMS = Key.makeMap(String.class);
    @Global
    @Expert
    public static final Key<String> FORM_METHOD = Key.make((String)"POST");

    public String getLoginUri(ProcessorURI context) {
        return (String)context.get(this, LOGIN_URI);
    }

    public String getHttpMethod(ProcessorURI context) {
        return (String)context.get(this, FORM_METHOD);
    }

    public Map<String, String> getFormItems(ProcessorURI context) {
        return (Map)context.get(this, FORM_ITEMS);
    }

    @Override
    public boolean isPrerequisite(ProcessorURI curi) {
        boolean result = false;
        String curiStr = curi.getUURI().toString();
        String loginUri = this.getPrerequisite(curi);
        if (loginUri != null) {
            try {
                UURI uuri = UURIFactory.getInstance((UURI)curi.getUURI(), (String)loginUri);
                if (uuri != null && curiStr != null && uuri.toString().equals(curiStr)) {
                    result = true;
                    if (!curi.isPrerequisite()) {
                        curi.setPrerequisite(true);
                        logger.fine(curi + " is prereq.");
                    }
                }
            }
            catch (URIException e) {
                logger.severe("Failed to uuri: " + curi + ", " + e.getMessage());
            }
        }
        return result;
    }

    @Override
    public boolean hasPrerequisite(ProcessorURI curi) {
        return this.getPrerequisite(curi) != null;
    }

    @Override
    public String getPrerequisite(ProcessorURI curi) {
        return this.getLoginUri(curi);
    }

    @Override
    public String getKey(ProcessorURI curi) {
        return this.getLoginUri(curi);
    }

    @Override
    public boolean isEveryTime() {
        return false;
    }

    @Override
    public boolean populate(ProcessorURI curi, HttpClient http, HttpMethod method, String payload) {
        boolean result = false;
        Map<String, String> formItems = this.getFormItems(curi);
        if (formItems == null || formItems.size() <= 0) {
            try {
                logger.severe("No form items for " + method.getURI());
            }
            catch (URIException e) {
                logger.severe("No form items and exception getting uri: " + e.getMessage());
            }
            return result;
        }
        NameValuePair[] data = new NameValuePair[formItems.size()];
        int index = 0;
        String key2 = null;
        for (String key2 : formItems.keySet()) {
            data[index++] = new NameValuePair(key2, formItems.get(key2));
        }
        if (method instanceof PostMethod) {
            ((PostMethod)method).setRequestBody(data);
            result = true;
        } else if (method instanceof GetMethod) {
            HttpMethodBase hmb = (HttpMethodBase)method;
            String currentQuery = hmb.getQueryString();
            hmb.setQueryString(data);
            String newQuery = hmb.getQueryString();
            hmb.setQueryString((StringUtils.isNotEmpty((String)currentQuery) ? currentQuery + "&" : "") + newQuery);
            result = true;
        } else {
            logger.severe("Unknown method type: " + method);
        }
        return result;
    }

    @Override
    public boolean isPost(ProcessorURI curi) {
        String method = this.getHttpMethod(curi);
        return method != null && method.equalsIgnoreCase("POST");
    }

    static {
        KeyManager.addKeys(HtmlFormCredential.class);
    }
}

