/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.credential;

import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.archive.modules.ProcessorURI;
import org.archive.modules.credential.Credential;
import org.archive.state.Expert;
import org.archive.state.Global;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class Rfc2617Credential
extends Credential {
    private static final long serialVersionUID = 3L;
    private static Logger logger = Logger.getLogger(Rfc2617Credential.class.getName());
    @Global
    @Expert
    public static final Key<String> REALM = Key.make((String)"Realm");
    @Global
    @Expert
    public static final Key<String> LOGIN = Key.make((String)"login");
    @Global
    @Expert
    public static final Key<String> PASSWORD = Key.make((String)"password");

    public String getRealm(ProcessorURI context) {
        return (String)context.get(this, REALM);
    }

    public String getLogin(ProcessorURI context) {
        return (String)context.get(this, LOGIN);
    }

    public String getPassword(ProcessorURI context) {
        return (String)context.get(this, PASSWORD);
    }

    public boolean isPrerequisite(ProcessorURI curi) {
        return false;
    }

    public boolean hasPrerequisite(ProcessorURI curi) {
        return false;
    }

    public String getPrerequisite(ProcessorURI curi) {
        return null;
    }

    public String getKey(ProcessorURI context) {
        return this.getRealm(context);
    }

    public boolean isEveryTime() {
        return true;
    }

    public boolean populate(ProcessorURI curi, HttpClient http, HttpMethod method, String payload) {
        boolean result = false;
        String authRealm = payload;
        if (authRealm == null) {
            logger.severe("No authscheme though creds: " + curi);
            return result;
        }
        UsernamePasswordCredentials upc = null;
        try {
            upc = new UsernamePasswordCredentials(this.getLogin(curi), this.getPassword(curi));
            http.getState().setCredentials(new AuthScope(curi.getUURI().getHost(), curi.getUURI().getPort(), authRealm), (Credentials)upc);
            logger.fine("Credentials for realm " + authRealm + " for CrawlURI " + curi.toString() + " added to request: " + result);
            result = true;
        }
        catch (URIException e) {
            logger.severe("Failed to parse host from " + curi + ": " + e.getMessage());
        }
        return result;
    }

    public boolean isPost(ProcessorURI curi) {
        return false;
    }

    public static Rfc2617Credential getByRealm(Set rfc2617Credentials, String realm, ProcessorURI context) {
        Rfc2617Credential result = null;
        if (rfc2617Credentials == null || rfc2617Credentials.size() <= 0) {
            return result;
        }
        if (rfc2617Credentials != null && rfc2617Credentials.size() > 0) {
            for (Rfc2617Credential c : rfc2617Credentials) {
                if (!c.getRealm(context).equals(realm)) continue;
                result = c;
                break;
            }
        }
        return result;
    }

    static {
        KeyManager.addKeys(Rfc2617Credential.class);
    }
}

