/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.PredicatedAcceptDecideRule;
import org.archive.net.UURI;

public class AddRedirectFromRootServerToScope
extends PredicatedAcceptDecideRule {
    private static final long serialVersionUID = 3L;
    private static final Logger LOGGER = Logger.getLogger(AddRedirectFromRootServerToScope.class.getName());
    private static final String SLASH = "/";

    protected boolean evaluate(ProcessorURI uri) {
        UURI via = uri.getVia();
        if (via == null) {
            return false;
        }
        try {
            String chost = uri.getUURI().getHostBasename();
            if (chost == null) {
                return false;
            }
            String viaHost = via.getHostBasename();
            if (viaHost == null) {
                return false;
            }
            if (chost.equals(viaHost) && uri.isLocation() && via.getPath().equals(SLASH)) {
                uri.setSeed(true);
                LOGGER.info("Adding " + uri + " to seeds via " + via);
                return true;
            }
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        return false;
    }
}

