/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;
import org.archive.settings.KeyChangeEvent;
import org.archive.settings.KeyChangeListener;
import org.archive.settings.SheetManager;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Path;
import org.archive.state.StateProvider;

public class BeanShellDecideRule
extends DecideRule
implements Initializable,
KeyChangeListener {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(BeanShellDecideRule.class.getName());
    @Immutable
    public static final Key<Path> SCRIPT_FILE = Key.make((Path)new Path(""));
    public static final Key<SheetManager> MANAGER = Key.makeAuto(SheetManager.class);
    @Immutable
    public static final Key<Boolean> ISOLATE_THREADS = Key.make((boolean)true);
    protected ThreadLocal<Interpreter> threadInterpreter = new ThreadLocal();
    protected Interpreter sharedInterpreter;
    public Map<Object, Object> sharedMap = Collections.synchronizedMap(new HashMap());
    protected boolean initialized = false;
    private Path scriptFile;
    private SheetManager manager;

    public void initialTasks(StateProvider context) {
        this.scriptFile = (Path)context.get((Object)this, SCRIPT_FILE);
        this.manager = (SheetManager)context.get((Object)this, MANAGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DecideResult innerDecide(ProcessorURI uri) {
        Interpreter interpreter;
        Interpreter interpreter2 = interpreter = this.getInterpreter(uri);
        synchronized (interpreter2) {
            try {
                interpreter.set("object", (Object)uri);
                return (DecideResult)((Object)interpreter.eval("decisionFor(object)"));
            }
            catch (EvalError e) {
                e.printStackTrace();
                return DecideResult.PASS;
            }
        }
    }

    protected Interpreter getInterpreter(StateProvider context) {
        if (this.sharedInterpreter == null && ((Boolean)context.get((Object)this, ISOLATE_THREADS)).booleanValue()) {
            this.sharedInterpreter = this.newInterpreter(context);
        }
        if (this.sharedInterpreter != null) {
            return this.sharedInterpreter;
        }
        Interpreter interpreter = this.threadInterpreter.get();
        if (interpreter == null) {
            interpreter = this.newInterpreter(context);
            this.threadInterpreter.set(interpreter);
        }
        return interpreter;
    }

    protected Interpreter newInterpreter(StateProvider context) {
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.set("self", (Object)this);
            interpreter.set("manager", (Object)this.manager);
            File file = this.scriptFile.toFile();
            try {
                interpreter.source(file.getPath());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "unable to read script file", e);
            }
        }
        catch (EvalError e) {
            e.printStackTrace();
        }
        return interpreter;
    }

    public void keyChanged(KeyChangeEvent event) {
        if (event.getKey() == ISOLATE_THREADS) {
            boolean isolate = (Boolean)event.getNewValue();
            if (isolate) {
                this.sharedInterpreter = null;
                this.threadInterpreter = new ThreadLocal();
            } else {
                this.sharedInterpreter = this.newInterpreter(event.getStateProvider());
                this.threadInterpreter = null;
            }
        }
    }

    static {
        KeyManager.addKeys(BeanShellDecideRule.class);
    }
}

