/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class ContentLengthDecideRule
extends DecideRule {
    private static final long serialVersionUID = 3L;
    public static final Key<Long> CONTENT_LENGTH_THRESHOLD = Key.make((long)Long.MAX_VALUE);

    protected DecideResult innerDecide(ProcessorURI uri) {
        if (uri.getContentLength() < (Long)uri.get(this, CONTENT_LENGTH_THRESHOLD)) {
            return DecideResult.ACCEPT;
        }
        return DecideResult.REJECT;
    }

    static {
        KeyManager.addKeys(ContentLengthDecideRule.class);
    }
}

