/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.io.Serializable;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Module;

public abstract class DecideRule
implements Module,
Serializable {
    public static final Key<Boolean> ENABLED = Key.make((boolean)true);
    public static final Key<String> COMMENT = Key.make((String)"");

    public DecideRule() {
        KeyManager.addKeys(this.getClass());
    }

    public DecideResult decisionFor(ProcessorURI uri) {
        if (!((Boolean)uri.get(this, ENABLED)).booleanValue()) {
            return DecideResult.PASS;
        }
        DecideResult result = this.innerDecide(uri);
        if (result == DecideResult.PASS) {
            return result;
        }
        return result;
    }

    protected abstract DecideResult innerDecide(ProcessorURI var1);

    public DecideResult onlyDecision(ProcessorURI uri) {
        return null;
    }

    public boolean accepts(ProcessorURI uri) {
        return DecideResult.ACCEPT == this.decisionFor(uri);
    }

    static {
        KeyManager.addKeys(DecideRule.class);
    }
}

