/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class DecideRuleSequence
extends DecideRule {
    private static final Logger LOGGER = Logger.getLogger(DecideRuleSequence.class.getName());
    private static final long serialVersionUID = 3L;
    public static final Key<List<DecideRule>> RULES = Key.makeList(DecideRule.class);

    public DecideResult innerDecide(ProcessorURI uri) {
        DecideResult result = DecideResult.PASS;
        List rules = (List)uri.get(this, RULES);
        int max = rules.size();
        for (int i = 0; i < max; ++i) {
            DecideRule rule = (DecideRule)rules.get(i);
            if (rule.onlyDecision(uri) == result) continue;
            DecideResult r = rule.decisionFor(uri);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("DecideRule #" + i + " " + rule.getClass().getName() + " returned " + (Object)((Object)r));
            }
            if (r == DecideResult.PASS) continue;
            result = r;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("DecideRuleSequence returned " + (Object)((Object)result));
        }
        return result;
    }

    static {
        KeyManager.addKeys(DecideRuleSequence.class);
        KeyManager.addKeys(DecideRuleSequence.class);
    }
}

