/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.ExternalGeoLookupInterface;
import org.archive.modules.deciderules.PredicatedAcceptDecideRule;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;
import org.xbill.DNS.Address;

public class ExternalGeoLocationDecideRule
extends PredicatedAcceptDecideRule
implements Initializable {
    private static final long serialVersionUID = 3L;
    private static final Logger LOGGER = Logger.getLogger(ExternalGeoLocationDecideRule.class.getName());
    public static final Key<ExternalGeoLookupInterface> LOOKUP = Key.make(ExternalGeoLookupInterface.class, null);
    public static final Key<String> COUNTRY_CODE = Key.make((String)"--");
    public static final Key<ServerCache> SERVER_CACHE = Key.makeAuto(ServerCache.class);
    private ServerCache serverCache;

    public void initialTasks(StateProvider provider) {
        this.serverCache = (ServerCache)provider.get((Object)this, SERVER_CACHE);
    }

    protected boolean evaluate(ProcessorURI uri) {
        String countryCode = (String)uri.get(this, COUNTRY_CODE);
        ExternalGeoLookupInterface impl = (ExternalGeoLookupInterface)uri.get(this, LOOKUP);
        if (impl == null) {
            return false;
        }
        CrawlHost crawlHost = null;
        try {
            String host = uri.getUURI().getHost();
            crawlHost = this.serverCache.getHostFor(host);
            if (crawlHost.getCountryCode() != null) {
                return crawlHost.getCountryCode().equals(countryCode);
            }
            InetAddress address = crawlHost.getIP();
            if (address == null) {
                address = Address.getByName((String)host);
            }
            crawlHost.setCountryCode(impl.lookup(address));
            if (crawlHost.getCountryCode().equals(countryCode)) {
                LOGGER.fine("Country Code Lookup:  " + host + crawlHost.getCountryCode());
                return true;
            }
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.FINE, "Failed dns lookup " + uri, e);
            if (crawlHost != null) {
                crawlHost.setCountryCode((String)COUNTRY_CODE.getDefaultValue());
            }
        }
        catch (URIException e) {
            LOGGER.log(Level.FINE, "Failed to parse hostname " + uri, e);
        }
        return false;
    }

    static {
        KeyManager.addKeys(ExternalGeoLocationDecideRule.class);
    }
}

