/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.logging.Logger;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.PredicatedDecideRule;
import org.archive.net.PublicSuffixes;
import org.archive.net.UURI;

public class IsCrossTopmostAssignedSurtHopDecideRule
extends PredicatedDecideRule {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(IsCrossTopmostAssignedSurtHopDecideRule.class.getName());

    protected boolean evaluate(ProcessorURI uri) {
        UURI via = uri.getVia();
        if (via == null) {
            return false;
        }
        try {
            String myTopmostAssignedSurt = this.getTopmostAssignedSurt(uri.getUURI());
            String viaTopmostAssignetSurt = this.getTopmostAssignedSurt(via);
            if (myTopmostAssignedSurt != null && viaTopmostAssignetSurt != null && !myTopmostAssignedSurt.equals(viaTopmostAssignetSurt)) {
                LOGGER.fine("rule matched for \"" + myTopmostAssignedSurt + "\" vs. \"" + viaTopmostAssignetSurt + "\"");
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private String getTopmostAssignedSurt(UURI uuri) {
        String surt = uuri.getSurtForm().replaceFirst(".*://\\((.*?)\\).*", "$1");
        return PublicSuffixes.reduceSurtToTopmostAssigned((String)surt);
    }

    protected DecideResult getDefaultDecision(ProcessorURI uri) {
        return DecideResult.REJECT;
    }
}

