/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.regex.Pattern;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.MatchesRegExpDecideRule;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class MatchesFilePatternDecideRule
extends MatchesRegExpDecideRule {
    private static final long serialVersionUID = 3L;
    public static final Key<Preset> USE_PRESET_PATTERN = Key.make((Enum)Preset.ALL);

    protected Pattern getPattern(ProcessorURI uri) {
        Preset preset = (Preset)((Object)uri.get(this, USE_PRESET_PATTERN));
        if (preset == Preset.CUSTOM) {
            return (Pattern)uri.get(this, REGEXP);
        }
        return preset.getPattern();
    }

    static {
        KeyManager.addKeys(MatchesFilePatternDecideRule.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Preset {
        ALL(".*(?i)(\\.(bmp|gif|jpe?g|png|tiff?|mid|mp2|mp3|mp4|wav|avi|mov|mpeg|ram|rm|smil|wmv|doc|pdf|ppt|swf))$"),
        IMAGES(".*(?i)(\\.(bmp|gif|jpe?g|png|tiff?))$"),
        AUDIO(".*(?i)(\\.(mid|mp2|mp3|mp4|wav))$"),
        VIDEO(".*(?i)(\\.(avi|mov|mpeg|ram|rm|smil|wmv))$"),
        MISC(".*(?i)(\\.(doc|pdf|ppt|swf))$"),
        CUSTOM(null);

        private final Pattern pattern;

        private Preset(String regexp) {
            this.pattern = regexp == null ? null : Pattern.compile(regexp);
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

