/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.PredicatedAcceptDecideRule;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class MatchesListRegExpDecideRule
extends PredicatedAcceptDecideRule {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(MatchesListRegExpDecideRule.class.getName());
    public static final Key<List<Pattern>> REGEXP_LIST = Key.makeList(Pattern.class);
    public static final Key<Boolean> LIST_LOGICAL_OR = Key.make((boolean)true);

    protected boolean evaluate(ProcessorURI uri) {
        List regexps = (List)uri.get(this, REGEXP_LIST);
        if (regexps.size() == 0) {
            return false;
        }
        String str = uri.toString();
        boolean listLogicOR = (Boolean)uri.get(this, LIST_LOGICAL_OR);
        for (Pattern p : regexps) {
            boolean matches = p.matcher(str).matches();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Tested '" + str + "' match with regex '" + p.pattern() + " and result was " + matches);
            }
            if (matches) {
                if (!listLogicOR) continue;
                logger.fine("Matched: " + str);
                return true;
            }
            if (listLogicOR) continue;
            return false;
        }
        return !listLogicOR;
    }

    static {
        KeyManager.addKeys(MatchesListRegExpDecideRule.class);
    }
}

