/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpMethod;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.PredicatedAcceptDecideRule;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class NotExceedsDocumentLengthTresholdDecideRule
extends PredicatedAcceptDecideRule {
    private static final long serialVersionUID = -8774160016195991876L;
    private static final Logger logger = Logger.getLogger(NotExceedsDocumentLengthTresholdDecideRule.class.getName());
    public static final Key<Boolean> USE_AS_MIDFETCH_RULE = Key.make((boolean)true);
    public static final Key<Integer> CONTENT_LENGTH_THRESHOLD = Key.make((int)-1);
    public static final int HEADER_PREDICTS_MISSING = -1;

    protected boolean evaluate(ProcessorURI curi) {
        int contentlength = -1;
        if (((Boolean)curi.get(this, USE_AS_MIDFETCH_RULE)).booleanValue()) {
            if (curi.getHttpMethod() == null) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Error: Missing HttpMethod object in CrawlURI. " + curi.toString());
                }
                return false;
            }
            HttpMethod method = curi.getHttpMethod();
            String newContentlength = null;
            if (method.getResponseHeader("content-length") != null) {
                newContentlength = method.getResponseHeader("content-length").getValue();
            }
            if (newContentlength != null && newContentlength.length() > 0) {
                try {
                    contentlength = Integer.parseInt(newContentlength);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (contentlength == -1) {
                return false;
            }
        } else {
            contentlength = (int)curi.getContentSize();
        }
        return contentlength < (Integer)curi.get(this, CONTENT_LENGTH_THRESHOLD);
    }

    boolean decision(ProcessorURI curi, int contentlength) {
        return contentlength < (Integer)curi.get(this, CONTENT_LENGTH_THRESHOLD);
    }

    static {
        KeyManager.addKeys(NotExceedsDocumentLengthTresholdDecideRule.class);
    }
}

