/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;
import org.archive.settings.KeyChangeEvent;
import org.archive.settings.KeyChangeListener;
import org.archive.state.Global;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class PathologicalPathDecideRule
extends DecideRule
implements KeyChangeListener {
    private static final long serialVersionUID = 3L;
    @Global
    public static final Key<Integer> MAX_REPETITIONS = Key.make((int)2);
    private AtomicReference<Pattern> pattern = new AtomicReference();

    protected DecideResult innerDecide(ProcessorURI uri) {
        int maxRep = (Integer)uri.get(this, MAX_REPETITIONS);
        Pattern p = this.getPattern(maxRep);
        if (p.matcher(uri.getUURI().toString()).matches()) {
            return DecideResult.REJECT;
        }
        return DecideResult.PASS;
    }

    private Pattern getPattern(int maxRep) {
        Pattern p = this.pattern.get();
        if (p != null) {
            return p;
        }
        String regex = this.constructRegexp(maxRep);
        p = Pattern.compile(regex);
        this.pattern.set(p);
        return p;
    }

    protected String constructRegexp(int rep) {
        return rep == 0 ? null : ".*?/(.*?/)\\1{" + rep + ",}.*";
    }

    public void keyChanged(KeyChangeEvent event) {
        this.pattern.set(null);
    }

    static {
        KeyManager.addKeys(PathologicalPathDecideRule.class);
    }
}

