/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.PredicatedRejectDecideRule;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class TooManyHopsDecideRule
extends PredicatedRejectDecideRule {
    private static final long serialVersionUID = 3L;
    public static final Key<Integer> MAX_HOPS = Key.make((int)20);
    static final Integer DEFAULT_MAX_HOPS = new Integer(20);

    protected boolean evaluate(ProcessorURI uri) {
        String hops = uri.getPathFromSeed();
        if (hops == null) {
            return false;
        }
        return hops.length() > (Integer)uri.get(this, MAX_HOPS);
    }

    static {
        KeyManager.addKeys(TooManyHopsDecideRule.class);
    }
}

