/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.PredicatedRejectDecideRule;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class TooManyPathSegmentsDecideRule
extends PredicatedRejectDecideRule {
    private static final long serialVersionUID = 3L;
    public static final Key<Integer> MAX_PATH_DEPTH = Key.make((int)20);

    protected boolean evaluate(ProcessorURI curi) {
        String uri = curi.toString();
        int count = 0;
        int threshold = (Integer)curi.get(this, MAX_PATH_DEPTH);
        for (int i = 0; i < uri.length(); ++i) {
            if (uri.charAt(i) == '/') {
                ++count;
            }
            if (count <= threshold) continue;
            return true;
        }
        return false;
    }

    static {
        KeyManager.addKeys(TooManyPathSegmentsDecideRule.class);
    }
}

