/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.PredicatedAcceptDecideRule;
import org.archive.modules.extractor.Hop;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class TransclusionDecideRule
extends PredicatedAcceptDecideRule {
    private static final long serialVersionUID = -3975688876990558918L;
    public static final Key<Integer> MAX_TRANS_HOPS = Key.make((int)2);
    public static final Key<Integer> MAX_SPECULATIVE_HOPS = Key.make((int)1);

    protected boolean evaluate(ProcessorURI curi) {
        char c;
        String hopsPath = curi.getPathFromSeed();
        if (hopsPath == null || hopsPath.length() == 0) {
            return false;
        }
        int count = 0;
        int specCount = 0;
        for (int i = hopsPath.length() - 1; i >= 0 && (c = hopsPath.charAt(i)) != Hop.NAVLINK.getHopChar(); --i) {
            ++count;
            if (c != Hop.SPECULATIVE.getHopChar()) continue;
            ++specCount;
        }
        if (count <= 0) {
            return false;
        }
        if (specCount > (Integer)curi.get(this, MAX_SPECULATIVE_HOPS)) {
            return false;
        }
        return count <= (Integer)curi.get(this, MAX_TRANS_HOPS);
    }

    static {
        KeyManager.addKeys(TransclusionDecideRule.class);
    }
}

