/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules.surt;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.surt.SurtPrefixedDecideRule;
import org.archive.net.UURI;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;
import org.archive.util.SurtPrefixSet;

public class ScopePlusOneDecideRule
extends SurtPrefixedDecideRule {
    private static final long serialVersionUID = 3L;
    public static final Key<Boolean> USE_DOMAIN = Key.make((boolean)true);
    public static final String ATTR_SCOPE = "host-or-domain-scope";
    public static final String HOST = "Host";
    public static final String DOMAIN = "Domain";
    private static final Logger logger = Logger.getLogger(ScopePlusOneDecideRule.class.getName());

    protected DecideResult innerDecide(ProcessorURI uri) {
        SurtPrefixSet set = this.getPrefixes(uri);
        UURI u = uri.getUURI();
        boolean firstResult = this.isInScope(u, set);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Tested scope of UURI itself '" + u + " and result was " + firstResult);
        }
        if (firstResult) {
            return DecideResult.ACCEPT;
        }
        UURI via = uri.getVia();
        if (via == null) {
            return DecideResult.PASS;
        }
        boolean result = this.isInScope(via, set);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Tested via UURI '" + via + " and result was " + result);
        }
        if (result) {
            return DecideResult.ACCEPT;
        }
        return DecideResult.PASS;
    }

    protected synchronized SurtPrefixSet getPrefixes() {
        return this.getPrefixes(null);
    }

    protected synchronized SurtPrefixSet getPrefixes(StateProvider o) {
        if (this.surtPrefixes == null) {
            this.readPrefixes(o);
        }
        return this.surtPrefixes;
    }

    protected void readPrefixes(StateProvider context) {
        this.buildSurtPrefixSet(context);
        if (((Boolean)context.get((Object)this, USE_DOMAIN)).booleanValue()) {
            this.surtPrefixes.convertAllPrefixesToDomains();
        } else {
            this.surtPrefixes.convertAllPrefixesToHosts();
        }
        this.dumpSurtPrefixSet(context);
    }

    private boolean isInScope(Object o, SurtPrefixSet set) {
        boolean iResult = false;
        UURI u = (UURI)o;
        if (u == null) {
            return false;
        }
        String candidateSurt = u.getSurtForm();
        if (candidateSurt.startsWith("https:")) {
            candidateSurt = "http:" + candidateSurt.substring(6);
        }
        if (set.containsPrefixOf(candidateSurt)) {
            iResult = true;
        }
        return iResult;
    }

    static {
        KeyManager.addKeys(ScopePlusOneDecideRule.class);
    }
}

