/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules.surt;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.PredicatedAcceptDecideRule;
import org.archive.modules.seeds.SeedListener;
import org.archive.modules.seeds.SeedModuleImpl;
import org.archive.net.UURI;
import org.archive.settings.KeyChangeEvent;
import org.archive.settings.KeyChangeListener;
import org.archive.state.Expert;
import org.archive.state.Global;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Path;
import org.archive.state.StateProvider;
import org.archive.util.SurtPrefixSet;

public class SurtPrefixedDecideRule
extends PredicatedAcceptDecideRule
implements SeedListener,
Initializable,
KeyChangeListener {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(SurtPrefixedDecideRule.class.getName());
    public static final Key<Path> SURTS_SOURCE_FILE = Key.make((Path)Path.EMPTY);
    public static final Key<Boolean> SEEDS_AS_SURT_PREFIXES = Key.make((boolean)true);
    @Expert
    public static final Key<Path> SURTS_DUMP_FILE = Key.make((Path)Path.EMPTY);
    @Expert
    @Global
    public static final Key<Boolean> REBUILD_ON_RECONFIG = Key.make((boolean)true);
    @Expert
    @Global
    public static final Key<Boolean> ALSO_CHECK_VIA = Key.make((boolean)false);
    @Immutable
    public static final Key<SeedModuleImpl> SEEDS = Key.makeAuto(SeedModuleImpl.class);
    protected SurtPrefixSet surtPrefixes = null;
    private SeedModuleImpl seeds;

    public void initialTasks(StateProvider provider) {
        this.seeds = (SeedModuleImpl)provider.get((Object)this, SEEDS);
        this.readPrefixes(provider);
    }

    protected boolean evaluate(ProcessorURI uri) {
        if (((Boolean)uri.get(this, ALSO_CHECK_VIA)).booleanValue() && this.innerDecide(uri, uri.getVia())) {
            return true;
        }
        return this.innerDecide(uri, uri.getUURI());
    }

    private boolean innerDecide(StateProvider context, UURI uuri) {
        String candidateSurt = SurtPrefixSet.getCandidateSurt((UURI)uuri);
        if (candidateSurt == null) {
            return false;
        }
        return this.getPrefixes(context).containsPrefixOf(candidateSurt);
    }

    private synchronized SurtPrefixSet getPrefixes(StateProvider uri) {
        if (this.surtPrefixes == null) {
            this.readPrefixes(uri);
        }
        return this.surtPrefixes;
    }

    protected void readPrefixes(StateProvider uri) {
        this.buildSurtPrefixSet(uri);
        this.dumpSurtPrefixSet(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpSurtPrefixSet(StateProvider uri) {
        Path dumpPath = (Path)uri.get((Object)this, SURTS_DUMP_FILE);
        if (!dumpPath.isEmpty()) {
            File dump = dumpPath.toFile();
            try {
                FileWriter fw = new FileWriter(dump);
                try {
                    this.surtPrefixes.exportTo(fw);
                }
                finally {
                    fw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildSurtPrefixSet(StateProvider uri) {
        boolean deduceFromSeeds;
        SurtPrefixSet newSurtPrefixes = new SurtPrefixSet();
        FileReader fr = null;
        Path sourcePath = (Path)uri.get((Object)this, SURTS_SOURCE_FILE);
        if (!sourcePath.isEmpty()) {
            File source = sourcePath.toFile();
            try {
                fr = new FileReader(source);
                try {
                    newSurtPrefixes.importFromMixed((Reader)fr, true);
                }
                finally {
                    fr.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Problem reading SURTs source file: " + e, e);
            }
        }
        if (deduceFromSeeds = ((Boolean)uri.get((Object)this, SEEDS_AS_SURT_PREFIXES)).booleanValue()) {
            try {
                fr = new FileReader(this.getSeedfile());
                try {
                    newSurtPrefixes.importFromMixed((Reader)fr, deduceFromSeeds);
                }
                finally {
                    fr.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Problem reading seeds file: " + e, e);
            }
        }
        this.surtPrefixes = newSurtPrefixes;
    }

    public synchronized void keyChanged(KeyChangeEvent event) {
        StateProvider provider = event.getStateProvider();
        if (((Boolean)provider.get((Object)this, REBUILD_ON_RECONFIG)).booleanValue()) {
            this.readPrefixes(provider);
        }
    }

    protected File getSeedfile() {
        this.seeds.addSeedListener(this);
        return this.seeds.getSeedfile();
    }

    public synchronized void addedSeed(ProcessorURI curi) {
        SurtPrefixSet newSurtPrefixes = (SurtPrefixSet)this.surtPrefixes.clone();
        newSurtPrefixes.add(this.prefixFrom(curi.toString()));
        this.surtPrefixes = newSurtPrefixes;
    }

    protected String prefixFrom(String uri) {
        return SurtPrefixSet.prefixFromPlainForceHttp((String)uri);
    }

    static {
        KeyManager.addKeys(SurtPrefixedDecideRule.class);
    }
}

