/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import java.nio.charset.CoderMalfunctionError;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.modules.extractor.UriErrorLoggerModule;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.StateProvider;

public abstract class Extractor
extends Processor
implements Initializable {
    private static final Logger logger = Logger.getLogger(Extractor.class.getName());
    @Immutable
    public static final Key<UriErrorLoggerModule> URI_ERROR_LOGGER_MODULE = Key.makeAuto(UriErrorLoggerModule.class);
    protected UriErrorLoggerModule uriErrors;

    public void initialTasks(StateProvider global) {
        this.uriErrors = (UriErrorLoggerModule)global.get((Object)this, URI_ERROR_LOGGER_MODULE);
    }

    protected final void innerProcess(ProcessorURI uri) throws InterruptedException {
        try {
            this.extract(uri);
        }
        catch (NullPointerException npe) {
            this.handleException(uri, npe);
        }
        catch (StackOverflowError soe) {
            this.handleException(uri, soe);
        }
        catch (CoderMalfunctionError cme) {
            this.handleException(uri, cme);
        }
    }

    private void handleException(ProcessorURI uri, Throwable t) {
        uri.getAnnotations().add("err=" + t.getClass().getName());
        uri.getNonFatalFailures().add(t);
        logger.log(Level.INFO, "Exception", t);
    }

    protected abstract void extract(ProcessorURI var1);

    protected void logUriError(URIException e, ProcessorURI uri, CharSequence l) {
        if (e.getReasonCode() == 9999999) {
            return;
        }
        this.uriErrors.logUriError(e, uri.getUURI(), l);
    }
}

