/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import java.io.IOException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.httpclient.URIException;
import org.archive.io.ReplayCharSequence;
import org.archive.modules.ProcessorURI;
import org.archive.modules.extractor.ContentExtractor;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.Link;
import org.archive.modules.extractor.LinkContext;
import org.archive.modules.extractor.UriErrorLoggerModule;
import org.archive.state.KeyManager;
import org.archive.util.DevUtils;
import org.archive.util.TextUtils;

public class ExtractorCSS
extends ContentExtractor {
    private static final long serialVersionUID = 2L;
    private static Logger logger = Logger.getLogger("org.archive.crawler.extractor.ExtractorCSS");
    private static String ESCAPED_AMP = "&amp";
    static final String CSS_BACKSLASH_ESCAPE = "\\\\([,'\"\\(\\)\\s])";
    static final String CSS_URI_EXTRACTOR = "(?i)(?:@import (?:url[(]|)|url[(])\\s*([\\\"']?)([^\\\"'].{0,2083}?)\\1\\s*[);]";
    private long numberOfLinksExtracted = 0L;

    protected boolean shouldExtract(ProcessorURI curi) {
        String mimeType = curi.getContentType();
        if (mimeType == null) {
            return false;
        }
        return mimeType.toLowerCase().indexOf("css") >= 0 || curi.toString().toLowerCase().endsWith(".css");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean innerExtract(ProcessorURI curi) {
        ReplayCharSequence cs = null;
        try {
            cs = curi.getRecorder().getReplayCharSequence();
        }
        catch (IOException e) {
            logger.severe("Failed getting ReplayCharSequence: " + e.getMessage());
        }
        if (cs == null) {
            logger.warning("Failed getting ReplayCharSequence: " + curi.toString());
            return false;
        }
        try {
            this.numberOfLinksExtracted += ExtractorCSS.processStyleCode(this.uriErrors, curi, (CharSequence)cs);
            boolean bl = true;
            return bl;
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (IOException ioe) {
                    logger.warning(TextUtils.exceptionToString((String)"Failed close of ReplayCharSequence.", (Throwable)ioe));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long processStyleCode(UriErrorLoggerModule uriErrors, ProcessorURI curi, CharSequence cs) {
        long foundLinks = 0L;
        Matcher uris = null;
        try {
            uris = TextUtils.getMatcher((String)CSS_URI_EXTRACTOR, (CharSequence)cs);
            while (uris.find()) {
                String cssUri = uris.group(2);
                cssUri = TextUtils.replaceAll((String)ESCAPED_AMP, (CharSequence)cssUri, (String)"&");
                cssUri = TextUtils.replaceAll((String)CSS_BACKSLASH_ESCAPE, (CharSequence)cssUri, (String)"$1");
                ++foundLinks;
                int max = uriErrors.getMaxOutlinks(curi);
                try {
                    Link.addRelativeToBase(curi, max, cssUri, LinkContext.EMBED_MISC, Hop.EMBED);
                }
                catch (URIException e) {
                    uriErrors.logUriError(e, curi.getUURI(), cssUri);
                }
            }
        }
        catch (StackOverflowError e) {
            DevUtils.warnHandle((Throwable)e, (String)"ExtractorCSS StackOverflowError");
        }
        finally {
            TextUtils.recycleMatcher((Matcher)uris);
        }
        return foundLinks;
    }

    public String report() {
        StringBuffer ret = new StringBuffer();
        ret.append("Processor: org.archive.crawler.extractor.ExtractorCSS\n");
        ret.append("  Function:          Link extraction on Cascading Style Sheets (.css)\n");
        ret.append("  ExtractorURIs handled: " + this.getURICount() + "\n");
        ret.append("  Links extracted:   " + this.numberOfLinksExtracted + "\n\n");
        return ret.toString();
    }

    static {
        KeyManager.addKeys(ExtractorCSS.class);
    }
}

