/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.ProcessorURI;
import org.archive.modules.extractor.Extractor;
import org.archive.modules.extractor.HTMLLinkContext;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.Link;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.state.KeyManager;

public class ExtractorHTTP
extends Extractor {
    private static final long serialVersionUID = 3L;
    protected long numberOfLinksExtracted = 0L;

    protected boolean shouldProcess(ProcessorURI uri) {
        if (uri.getFetchStatus() <= 0) {
            return false;
        }
        ProcessorURI.FetchType ft = uri.getFetchType();
        return ft == ProcessorURI.FetchType.HTTP_GET || ft == ProcessorURI.FetchType.HTTP_POST;
    }

    protected void extract(ProcessorURI curi) {
        HttpMethod method = curi.getHttpMethod();
        this.addHeaderLink(curi, method.getResponseHeader("Location"));
        this.addHeaderLink(curi, method.getResponseHeader("Content-Location"));
    }

    protected void addHeaderLink(ProcessorURI curi, Header loc) {
        if (loc == null) {
            return;
        }
        try {
            UURI dest = UURIFactory.getInstance((UURI)curi.getUURI(), (String)loc.getValue());
            HTMLLinkContext lc = new HTMLLinkContext(loc.getName());
            Link link = new Link((CharSequence)curi.getUURI(), (CharSequence)dest, lc, Hop.REFER);
            curi.getOutLinks().add(link);
            ++this.numberOfLinksExtracted;
        }
        catch (URIException e) {
            this.logUriError(e, curi, loc.getValue());
        }
    }

    public String report() {
        StringBuffer ret = new StringBuffer();
        ret.append("Processor: org.archive.crawler.extractor.ExtractorHTTP\n");
        ret.append("  Function:          Extracts URIs from HTTP response headers\n");
        ret.append("  CrawlURIs handled: " + this.getURICount());
        ret.append("  Links extracted:   " + this.numberOfLinksExtracted + "\n\n");
        return ret.toString();
    }

    static {
        KeyManager.addKeys(ExtractorHTTP.class);
    }
}

