/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.readers.SWFReader;
import com.anotherbigidea.flash.readers.TagParser;
import com.anotherbigidea.io.InStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.archive.io.ReplayInputStream;
import org.archive.modules.ProcessorURI;
import org.archive.modules.extractor.ContentExtractor;
import org.archive.modules.extractor.CrawlUriSWFAction;
import org.archive.modules.extractor.CustomSWFTags;
import org.archive.state.KeyManager;

public class ExtractorSWF
extends ContentExtractor {
    private static final long serialVersionUID = 3L;
    private static Logger logger = Logger.getLogger(ExtractorSWF.class.getName());
    protected AtomicLong linksExtracted = new AtomicLong(0L);
    private static final int MAX_READ_SIZE = 0x100000;

    protected boolean shouldExtract(ProcessorURI uri) {
        String contentType = uri.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().indexOf("x-shockwave-flash") >= 0 || uri.toString().toLowerCase().endsWith(".swf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean innerExtract(ProcessorURI curi) {
        ReplayInputStream documentStream = null;
        try {
            documentStream = curi.getRecorder().getRecordedInput().getContentReplayInputStream();
            if (documentStream == null) {
                boolean bl = false;
                return bl;
            }
            CrawlUriSWFAction curiAction = new CrawlUriSWFAction(this.uriErrors, curi);
            CustomSWFTags customTags = new CustomSWFTags((SWFActions)curiAction);
            SWFReader reader = new SWFReader((SWFTags)this.getTagParser(customTags), (InputStream)documentStream){

                public int readOneTag() throws IOException {
                    boolean longTag;
                    int header = this.mIn.readUI16();
                    int type = header >> 6;
                    int length = header & 0x3F;
                    boolean bl = longTag = length == 63;
                    if (longTag) {
                        length = (int)this.mIn.readUI32();
                    }
                    if (length > 0x100000) {
                        this.mIn.skipBytes((long)length);
                        logger.info("oversized SWF tag (type=" + type + ";length=" + length + ") skipped");
                    } else {
                        byte[] contents = this.mIn.read(length);
                        this.mConsumer.tag(type, longTag, contents);
                    }
                    return type;
                }
            };
            reader.readFile();
            this.linksExtracted.addAndGet(curiAction.getLinkCount());
            logger.fine(curi + " has " + curiAction.getLinkCount() + " links.");
        }
        catch (IOException e) {
            curi.getNonFatalFailures().add(e);
        }
        finally {
            try {
                documentStream.close();
            }
            catch (IOException e) {
                curi.getNonFatalFailures().add(e);
            }
        }
        return true;
    }

    public String report() {
        StringBuffer ret = new StringBuffer();
        ret.append("Processor: org.archive.crawler.extractor.ExtractorSWF\n");
        ret.append("  Function:          Link extraction on Shockwave Flash documents (.swf)\n");
        ret.append("  CrawlURIs handled: " + this.getURICount() + "\n");
        ret.append("  Links extracted:   " + this.linksExtracted + "\n\n");
        return ret.toString();
    }

    private TagParser getTagParser(CustomSWFTags customTags) {
        return new ExtractorTagParser((SWFTagTypes)customTags);
    }

    static {
        KeyManager.addKeys(ExtractorSWF.class);
    }

    protected class ExtractorTagParser
    extends TagParser {
        protected ExtractorTagParser(SWFTagTypes tagtypes) {
            super(tagtypes);
        }

        protected void parseDefineBits(InStream in) throws IOException {
        }

        protected void parseDefineBitsJPEG3(InStream in) throws IOException {
        }

        protected void parseDefineBitsLossless(InStream in, int length, boolean hasAlpha) throws IOException {
        }

        protected void parseDefineButtonSound(InStream in) throws IOException {
        }

        protected void parseDefineFont(InStream in) throws IOException {
        }

        protected void parseDefineJPEG2(InStream in, int length) throws IOException {
        }

        protected void parseDefineJPEGTables(InStream in) throws IOException {
        }

        protected void parseDefineShape(int type, InStream in) throws IOException {
        }

        protected void parseDefineSound(InStream in) throws IOException {
        }

        protected void parseFontInfo(InStream in, int length, boolean isFI2) throws IOException {
        }

        protected void parseDefineFont2(InStream in) throws IOException {
        }
    }
}

