/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.archive.io.ReplayCharSequence;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.util.TextUtils;

public class HTTPContentDigest
extends Processor {
    private static final long serialVersionUID = 3L;
    private static Logger logger = Logger.getLogger(HTTPContentDigest.class.getName());
    public static final Key<Pattern> STRIP_REG_EXPR = Key.makeNull(Pattern.class);
    public static final Key<Long> MAX_SIZE_BYTES = Key.make((long)0x100000L);
    private static final String SHA1 = "SHA1";

    protected boolean shouldProcess(ProcessorURI uri) {
        if (!uri.getContentType().startsWith("text")) {
            return false;
        }
        long maxSize = (Long)uri.get(this, MAX_SIZE_BYTES);
        return maxSize <= -1L || maxSize >= uri.getContentSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerProcess(ProcessorURI curi) throws InterruptedException {
        Pattern regexpr = (Pattern)curi.get(this, STRIP_REG_EXPR);
        ReplayCharSequence cs = null;
        try {
            cs = curi.getRecorder().getReplayCharSequence();
        }
        catch (Exception e) {
            curi.getNonFatalFailures().add(e);
            logger.warning("Failed get of replay char sequence " + curi.toString() + " " + e.getMessage() + " " + Thread.currentThread().getName());
            return;
        }
        MessageDigest digest = null;
        try {
            try {
                digest = MessageDigest.getInstance(SHA1);
            }
            catch (NoSuchAlgorithmException e1) {
                e1.printStackTrace();
                if (cs != null) {
                    try {
                        cs.close();
                    }
                    catch (IOException ioe) {
                        logger.warning(TextUtils.exceptionToString((String)"Failed close of ReplayCharSequence.", (Throwable)ioe));
                    }
                }
                return;
            }
            digest.reset();
            String s = null;
            if (regexpr != null) {
                s = cs.toString();
            } else {
                Matcher m = regexpr.matcher((CharSequence)cs);
                s = m.replaceAll(" ");
            }
            digest.update(s.getBytes());
            byte[] newDigestValue = digest.digest();
            curi.setContentDigest(SHA1, newDigestValue);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (IOException ioe) {
                    logger.warning(TextUtils.exceptionToString((String)"Failed close of ReplayCharSequence.", (Throwable)ioe));
                }
            }
        }
    }

    static {
        KeyManager.addKeys(HTTPContentDigest.class);
    }
}

