/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import java.io.Serializable;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.ProcessorURI;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.LinkContext;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;

public class Link
implements Serializable {
    private static final long serialVersionUID = 2L;
    private CharSequence source;
    private CharSequence destination;
    private LinkContext context;
    private Hop hop;

    public Link(CharSequence source, CharSequence destination, LinkContext context, Hop hop) {
        this.source = source;
        this.destination = destination;
        this.context = context;
        this.hop = hop;
    }

    public LinkContext getContext() {
        return this.context;
    }

    public CharSequence getDestination() {
        return this.destination;
    }

    public CharSequence getSource() {
        return this.source;
    }

    public Hop getHopType() {
        return this.hop;
    }

    public String toString() {
        return this.destination + " " + this.hop.getHopChar() + " " + this.context;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Link)) {
            return false;
        }
        Link l = (Link)o;
        return l.source.equals(this.source) && l.destination.equals(this.destination) && l.context.equals(this.context) && l.hop.equals((Object)this.hop);
    }

    public int hashCode() {
        int r = 37;
        return r ^ this.source.hashCode() ^ this.destination.hashCode() ^ this.context.hashCode() ^ this.hop.hashCode();
    }

    public static void addRelativeToBase(ProcessorURI uri, int max, String newUri, LinkContext context, Hop hop) throws URIException {
        UURI dest = UURIFactory.getInstance((UURI)uri.getUURI(), (String)newUri);
        Link.add2(uri, max, dest, context, hop);
    }

    public static void addRelativeToVia(ProcessorURI uri, int max, String newUri, LinkContext context, Hop hop) throws URIException {
        UURI dest = UURIFactory.getInstance((UURI)uri.getVia(), (String)newUri);
        Link.add2(uri, max, dest, context, hop);
    }

    public static void add(ProcessorURI uri, int max, String newUri, LinkContext context, Hop hop) throws URIException {
        UURI dest = UURIFactory.getInstance((String)newUri);
        Link.add2(uri, max, dest, context, hop);
    }

    private static void add2(ProcessorURI uri, int max, UURI dest, LinkContext context, Hop hop) throws URIException {
        if (uri.getOutLinks().size() < max) {
            UURI src = uri.getUURI();
            Link link = new Link((CharSequence)src, (CharSequence)dest, context, hop);
            uri.getOutLinks().add(link);
        } else {
            uri.incrementDiscardedOutLinks();
        }
    }
}

