/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFParser {
    ArrayList<String> foundURIs;
    ArrayList<ArrayList<Integer>> encounteredReferences;
    PdfReader documentReader;
    byte[] document;
    PdfDictionary catalog;

    public PDFParser(String doc) throws IOException {
        this.resetState();
        this.getInFromFile(doc);
        this.initialize();
    }

    public PDFParser(byte[] doc) throws IOException {
        this.resetState();
        this.document = doc;
        this.initialize();
    }

    protected void resetState() {
        this.foundURIs = new ArrayList();
        this.encounteredReferences = new ArrayList();
        this.documentReader = null;
        this.document = null;
        this.catalog = null;
        for (int i = 0; i < this.encounteredReferences.size(); ++i) {
            this.encounteredReferences.add(new ArrayList());
        }
    }

    public void resetState(byte[] doc) throws IOException {
        this.resetState();
        this.document = doc;
        this.initialize();
    }

    public void resetState(String doc) throws IOException {
        this.resetState();
        this.getInFromFile(doc);
        this.initialize();
    }

    protected void getInFromFile(String doc) throws IOException {
        File documentOnDisk = new File(doc);
        long length = documentOnDisk.length();
        this.document = new byte[(int)length];
        FileInputStream inStream = new FileInputStream(documentOnDisk);
        inStream.read(this.document);
    }

    protected boolean haveSeen(int generation, int id) {
        if (generation >= this.encounteredReferences.size()) {
            for (int i = this.encounteredReferences.size(); i <= generation; ++i) {
                this.encounteredReferences.add(new ArrayList());
            }
            return false;
        }
        ArrayList<Integer> generationList = this.encounteredReferences.get(generation);
        for (int i : generationList) {
            if (i != id) continue;
            return true;
        }
        return false;
    }

    protected void markAsSeen(int generation, int id) {
        ArrayList<Integer> objectIds = this.encounteredReferences.get(generation);
        objectIds.add(id);
    }

    public ArrayList<String> getURIs() {
        return this.foundURIs;
    }

    protected void initialize() throws IOException {
        if (this.document != null) {
            this.documentReader = new PdfReader(this.document);
        }
        this.catalog = this.documentReader.getCatalog();
    }

    public ArrayList<String> extractURIs() {
        this.extractURIs((PdfObject)this.catalog);
        return this.getURIs();
    }

    protected void extractURIs(PdfObject entity) {
        if (entity.isDictionary()) {
            PdfDictionary dictionary = (PdfDictionary)entity;
            Set allkeys = dictionary.getKeys();
            for (PdfName key : allkeys) {
                PdfObject value = dictionary.get(key);
                if (key.toString().equals("/URI") || key.toString().equals("/URL")) {
                    this.foundURIs.add(value.toString());
                    continue;
                }
                this.extractURIs(value);
            }
        } else if (entity.isArray()) {
            PdfArray array = (PdfArray)entity;
            ArrayList arrayObjects = array.getArrayList();
            Iterator objectList = arrayObjects.iterator();
            while (objectList.hasNext()) {
                this.extractURIs((PdfObject)objectList.next());
            }
        } else if (entity.getClass() == PRIndirectReference.class) {
            PRIndirectReference indirect = (PRIndirectReference)entity;
            if (this.haveSeen(indirect.getGeneration(), indirect.getNumber())) {
                return;
            }
            this.markAsSeen(indirect.getGeneration(), indirect.getNumber());
            indirect.getReader();
            PdfObject direct = PdfReader.getPdfObject((PdfObject)indirect);
            this.extractURIs(direct);
        }
    }

    public static void main(String[] argv) {
        try {
            PDFParser parser = new PDFParser("/home/parkert/files/pdfspec.pdf");
            ArrayList<String> uris = parser.extractURIs();
            for (String uri : uris) {
                System.out.println("got uri: " + uri);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

