/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import java.util.ArrayList;
import java.util.Collection;
import org.archive.modules.DefaultProcessorURI;
import org.archive.modules.extractor.ContentExtractorTestBase;
import org.archive.modules.extractor.Extractor;
import org.archive.modules.extractor.Link;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringExtractorTestBase
extends ContentExtractorTestBase {
    protected abstract String[] getValidTestData();

    protected abstract Collection<TestData> makeData(String var1, String var2) throws Exception;

    public void testExtraction() throws Exception {
        try {
            String[] valid = this.getValidTestData();
            for (int i = 0; i < valid.length; i += 2) {
                this.testOne(valid[i], valid[i + 1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void testOne(String text, String expectedURL) throws Exception {
        Collection<TestData> testDataCol = this.makeData(text, expectedURL);
        for (TestData testData : testDataCol) {
            Extractor extractor = this.makeExtractor();
            extractor.process(testData.uri);
            ArrayList<Link> expected = new ArrayList<Link>();
            expected.add(testData.expectedResult);
            StringExtractorTestBase.assertEquals(expected, (Object)testData.uri.getOutLinks());
            StringExtractorTestBase.assertNoSideEffects(testData.uri);
        }
    }

    public static class TestData {
        public DefaultProcessorURI uri;
        public Link expectedResult;

        public TestData(DefaultProcessorURI uri, Link expectedResult) {
            this.uri = uri;
            this.expectedResult = expectedResult;
        }
    }
}

