/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import java.util.logging.Logger;
import org.archive.modules.ProcessorURI;
import org.archive.modules.extractor.ContentExtractor;

public class TrapSuppressExtractor
extends ContentExtractor {
    private static final long serialVersionUID = -1028783453022579530L;
    private static final Logger LOGGER = Logger.getLogger(TrapSuppressExtractor.class.getName());
    public static String A_VIA_DIGEST = "via-digest";
    protected long numberOfCURIsHandled = 0L;
    protected long numberOfCURIsSuppressed = 0L;

    protected boolean shouldExtract(ProcessorURI uri) {
        return true;
    }

    protected boolean innerExtract(ProcessorURI curi) {
        ++this.numberOfCURIsHandled;
        String currentDigest = curi.getContentDigestSchemeString();
        String viaDigest = null;
        if (curi.containsDataKey(A_VIA_DIGEST)) {
            viaDigest = (String)curi.getData().get(A_VIA_DIGEST);
        }
        if (currentDigest != null) {
            curi.makeHeritable(A_VIA_DIGEST);
            if (currentDigest.equals(viaDigest)) {
                curi.getAnnotations().add("trapSuppressExtractor");
                ++this.numberOfCURIsSuppressed;
                return true;
            }
            curi.getData().put(A_VIA_DIGEST, currentDigest);
        }
        return false;
    }

    public String report() {
        StringBuffer ret = new StringBuffer();
        ret.append("Processor: org.archive.crawler.extractor.TrapSuppressExtractor\n");
        ret.append("  Function:             Suppress extraction on likely traps\n");
        ret.append("  CrawlURIs handled:    " + this.numberOfCURIsHandled + "\n");
        ret.append("  CrawlURIs suppressed: " + this.numberOfCURIsSuppressed + "\n\n");
        return ret.toString();
    }
}

