/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import it.unimi.dsi.mg4j.util.MutableString;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Cookie;
import org.archive.modules.fetcher.CookieStorage;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Path;
import org.archive.state.StateProvider;
import org.archive.util.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCookieStorage
implements CookieStorage,
Initializable,
Closeable,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(AbstractCookieStorage.class.getName());
    @Immutable
    public static final Key<Path> LOAD_COOKIES_FROM_FILE = Key.make((Path)Path.EMPTY);
    @Immutable
    public static final Key<Path> SAVE_COOKIES_TO_FILE = Key.make((Path)Path.EMPTY);
    private Path saveCookiesToFile;

    @Override
    public void initialTasks(StateProvider provider) {
        Path fname = (Path)provider.get((Object)this, LOAD_COOKIES_FROM_FILE);
        SortedMap<String, Cookie> cookies = this.prepareMap(provider);
        if (!fname.isEmpty()) {
            AbstractCookieStorage.loadCookies(fname.toFile().getAbsolutePath(), cookies);
        }
        this.saveCookiesToFile = (Path)provider.get((Object)this, SAVE_COOKIES_TO_FILE);
    }

    @Override
    public void finalTasks(StateProvider defaults) {
    }

    protected abstract SortedMap<String, Cookie> prepareMap(StateProvider var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void loadCookies(String cookiesFile, SortedMap<String, Cookie> result) {
        if (cookiesFile == null || cookiesFile.length() <= 0) {
            return;
        }
        RandomAccessFile raf = null;
        try {
            String line;
            raf = new RandomAccessFile(cookiesFile, "r");
            Cookie cookie = null;
            while ((line = raf.readLine()) != null) {
                String[] cookieParts;
                if (line.startsWith("#") || (cookieParts = line.split("\\t")).length != 7) continue;
                cookie = new Cookie(cookieParts[0], cookieParts[5], cookieParts[6], cookieParts[2], -1, Boolean.valueOf(cookieParts[3]).booleanValue());
                if (cookieParts[1].toLowerCase().equals("true")) {
                    cookie.setDomainAttributeSpecified(true);
                } else {
                    cookie.setDomainAttributeSpecified(false);
                }
                LOGGER.fine("Adding cookie: " + cookie.toExternalForm());
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find file: " + cookiesFile + " (Element: " + LOAD_COOKIES_FROM_FILE.getFieldName() + ")");
            IoUtils.close((Closeable)raf);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    IoUtils.close(raf);
                    throw throwable;
                }
            }
            IoUtils.close((Closeable)raf);
        }
        IoUtils.close((Closeable)raf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCookies(String saveCookiesFile, Map<String, Cookie> cookies) {
        if (saveCookiesFile == null || saveCookiesFile.length() <= 0) {
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(saveCookiesFile));
            String tab = "\t";
            out.write("# Heritrix Cookie File\n".getBytes());
            out.write("# This file is the Netscape cookies.txt format\n\n".getBytes());
            for (Cookie cookie : cookies.values()) {
                MutableString line = new MutableString(2048);
                line.append(cookie.getDomain());
                line.append(tab);
                line.append(cookie.isDomainAttributeSpecified() ? "TRUE" : "FALSE");
                line.append(tab);
                line.append(cookie.getPath());
                line.append(tab);
                line.append(cookie.getSecure() ? "TRUE" : "FALSE");
                line.append(tab);
                line.append(cookie.getName());
                line.append(tab);
                line.append(null == cookie.getValue() ? "" : cookie.getValue());
                line.append("\n");
                out.write(line.toString().getBytes());
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find file: " + saveCookiesFile + " (Element: " + SAVE_COOKIES_TO_FILE.getFieldName() + ")");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public abstract SortedMap<String, Cookie> getCookiesMap();

    @Override
    public void saveCookiesMap(Map<String, Cookie> map) {
        this.innerSaveCookiesMap(map);
        if (!this.saveCookiesToFile.isEmpty()) {
            AbstractCookieStorage.saveCookies(this.saveCookiesToFile.toFile().getAbsolutePath(), map);
        }
    }

    protected abstract void innerSaveCookiesMap(Map<String, Cookie> var1);

    @Override
    public void close() throws IOException {
    }

    static {
        KeyManager.addKeys(AbstractCookieStorage.class);
    }
}

