/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Cookie;
import org.archive.modules.fetcher.AbstractCookieStorage;
import org.archive.settings.file.BdbModule;
import org.archive.state.Immutable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BdbCookieStorage
extends AbstractCookieStorage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BdbCookieStorage.class.getName());
    @Immutable
    public static final Key<BdbModule> BDB = Key.makeAuto(BdbModule.class);
    public static String COOKIEDB_NAME = "http_cookies";
    private BdbModule bdb;
    private transient Database cookieDb;
    private transient StoredSortedMap cookies;

    @Override
    protected SortedMap<String, Cookie> prepareMap(StateProvider provider) {
        this.bdb = (BdbModule)provider.get((Object)this, BDB);
        try {
            StoredClassCatalog classCatalog = this.bdb.getClassCatalog();
            BdbModule.BdbConfig dbConfig = new BdbModule.BdbConfig();
            dbConfig.setTransactional(false);
            dbConfig.setAllowCreate(true);
            this.cookieDb = this.bdb.openDatabase(COOKIEDB_NAME, dbConfig, true);
            StoredSortedMap result = this.cookies = new StoredSortedMap(this.cookieDb, (EntryBinding)new StringBinding(), (EntryBinding)new SerialBinding((ClassCatalog)classCatalog, Cookie.class), true);
            return result;
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SortedMap<String, Cookie> getCookiesMap() {
        assert (this.cookies != null) : "cookie map not set up";
        return this.cookies;
    }

    @Override
    protected void innerSaveCookiesMap(Map<String, Cookie> map) {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        try {
            out.writeUTF(this.cookieDb.getDatabaseName());
        }
        catch (DatabaseException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.cookieDb = this.bdb.getDatabase(in.readUTF());
        this.cookies = new StoredSortedMap(this.cookieDb, (EntryBinding)new StringBinding(), (EntryBinding)new SerialBinding((ClassCatalog)this.bdb.getClassCatalog(), Cookie.class), true);
    }

    static {
        KeyManager.addKeys(BdbCookieStorage.class);
    }
}

