/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.Closeable;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.Closure;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.ServerCache;
import org.archive.net.UURI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServerCache
implements ServerCache,
Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(DefaultServerCache.class.getName());
    protected Map<String, CrawlServer> servers = null;
    protected Map<String, CrawlHost> hosts = null;

    public DefaultServerCache() {
        this(new Hashtable<String, CrawlServer>(), new Hashtable<String, CrawlHost>());
    }

    public DefaultServerCache(Map<String, CrawlServer> servers, Map<String, CrawlHost> hosts) {
        this.servers = servers;
        this.hosts = hosts;
    }

    @Override
    public synchronized CrawlServer getServerFor(String serverKey) {
        CrawlServer cserver = this.servers.get(serverKey);
        return cserver != null ? cserver : this.createServerFor(serverKey);
    }

    protected CrawlServer createServerFor(String s) {
        CrawlServer cserver = this.servers.get(s);
        if (cserver != null) {
            return cserver;
        }
        String skey = new String(s);
        cserver = new CrawlServer(skey);
        this.servers.put(skey, cserver);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Created server " + s);
        }
        return cserver;
    }

    public CrawlServer getServerFor(UURI uuri) {
        CrawlServer cs = null;
        try {
            String key = CrawlServer.getServerKey(uuri);
            if (key != null) {
                cs = this.getServerFor(key);
            }
        }
        catch (URIException e) {
            logger.severe(e.getMessage() + ": " + uuri);
            e.printStackTrace();
        }
        catch (NullPointerException npe) {
            logger.severe(npe.getMessage() + ": " + uuri);
            npe.printStackTrace();
        }
        return cs;
    }

    @Override
    public synchronized CrawlHost getHostFor(String hostname) {
        if (hostname == null || hostname.length() == 0) {
            return null;
        }
        CrawlHost host = this.hosts.get(hostname);
        return host != null ? host : this.createHostFor(hostname);
    }

    protected CrawlHost createHostFor(String hostname) {
        if (hostname == null || hostname.length() == 0) {
            return null;
        }
        CrawlHost host = this.hosts.get(hostname);
        if (host != null) {
            return host;
        }
        String hkey = new String(hostname);
        host = new CrawlHost(hkey);
        this.hosts.put(hkey, host);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Created host " + hostname);
        }
        return host;
    }

    public CrawlHost getHostFor(UURI uuri) {
        CrawlHost h = null;
        try {
            h = this.getHostFor(uuri.getReferencedHost());
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        return h;
    }

    public boolean containsServer(String serverKey) {
        return this.servers.get(serverKey) != null;
    }

    public boolean containsHost(String hostKey) {
        return this.hosts.get(hostKey) != null;
    }

    @Override
    public void close() {
        if (this.hosts != null) {
            this.hosts.clear();
            this.hosts = null;
        }
        if (this.servers != null) {
            this.servers.clear();
            this.servers = null;
        }
    }

    @Override
    public void forAllHostsDo(Closure c) {
        for (String host : this.hosts.keySet()) {
            c.execute((Object)this.hosts.get(host));
        }
    }
}

