/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.archive.state.Expert;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;
import org.archive.util.InetAddressUtil;
import org.archive.util.Recorder;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.TextParseException;

public class FetchDNS
extends Processor
implements Initializable {
    private static final long serialVersionUID = 3L;
    private static Logger logger = Logger.getLogger(FetchDNS.class.getName());
    private short ClassType = 1;
    private short TypeType = 1;
    protected InetAddress serverInetAddr = null;
    private ServerCache crawlHostCache;
    @Expert
    public static final Key<Boolean> ACCEPT_NON_DNS_RESOLVES = Key.make((boolean)false);
    @Immutable
    public static final Key<ServerCache> SERVER_CACHE = Key.makeAuto(ServerCache.class);
    @Expert
    public static final Key<Boolean> DIGEST_CONTENT = Key.make((boolean)true);
    @Expert
    public static final Key<String> DIGEST_ALGORITHM = Key.make((String)"sha1");
    private static final long DEFAULT_TTL_FOR_NON_DNS_RESOLVES = 21600L;
    private byte[] reusableBuffer = new byte[1024];

    public void initialTasks(StateProvider p) {
        this.crawlHostCache = (ServerCache)p.get((Object)this, SERVER_CACHE);
    }

    protected boolean shouldProcess(ProcessorURI curi) {
        return curi.getUURI().getScheme().equals("dns");
    }

    protected void innerProcess(ProcessorURI curi) {
        Record[] rrecordSet = null;
        String dnsName = null;
        try {
            dnsName = curi.getUURI().getReferencedHost();
        }
        catch (URIException e) {
            logger.log(Level.SEVERE, "Failed parse of dns record " + curi, e);
        }
        if (dnsName == null) {
            curi.setFetchStatus(-7);
            return;
        }
        CrawlHost targetHost = this.crawlHostCache.getHostFor(dnsName);
        if (this.isQuadAddress(curi, dnsName, targetHost)) {
            return;
        }
        curi.setFetchBeginTime(System.currentTimeMillis());
        try {
            rrecordSet = new Lookup(dnsName, (int)this.TypeType, (int)this.ClassType).run();
        }
        catch (TextParseException e) {
            rrecordSet = null;
        }
        curi.setContentType("text/dns");
        if (rrecordSet != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found recordset for " + dnsName);
            }
            this.storeDNSRecord(curi, dnsName, targetHost, rrecordSet);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Failed find of recordset for " + dnsName);
            }
            if (((Boolean)curi.get(this, ACCEPT_NON_DNS_RESOLVES)).booleanValue() || "localhost".equals(dnsName)) {
                InetAddress address = null;
                try {
                    address = InetAddress.getByName(dnsName);
                }
                catch (UnknownHostException e1) {
                    address = null;
                }
                if (address != null) {
                    targetHost.setIP(address, 21600L);
                    curi.setFetchStatus(1001);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Found address for " + dnsName + " using native dns.");
                    }
                } else {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Failed find of address for " + dnsName + " using native dns.");
                    }
                    this.setUnresolvable(curi, targetHost);
                }
            } else {
                this.setUnresolvable(curi, targetHost);
            }
        }
        curi.setFetchCompletedTime(System.currentTimeMillis());
    }

    protected void storeDNSRecord(ProcessorURI curi, String dnsName, CrawlHost targetHost, Record[] rrecordSet) {
        ARecord arecord = this.getFirstARecord(rrecordSet);
        if (arecord == null) {
            throw new NullPointerException("Got null arecord for " + dnsName);
        }
        targetHost.setIP(arecord.getAddress(), arecord.getTTL());
        try {
            this.recordDNS(curi, rrecordSet);
            curi.setFetchStatus(1);
            curi.setDNSServerIPLabel(ResolverConfig.getCurrentConfig().server());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed store of DNS Record for " + curi.toString(), e);
            this.setUnresolvable(curi, targetHost);
        }
    }

    protected boolean isQuadAddress(ProcessorURI curi, String dnsName, CrawlHost targetHost) {
        boolean result = false;
        Matcher matcher = InetAddressUtil.IPV4_QUADS.matcher(dnsName);
        if (matcher == null || !matcher.matches()) {
            return result;
        }
        result = true;
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Unnecessary DNS ProcessorURI created: " + curi);
        }
        try {
            targetHost.setIP(InetAddress.getByAddress(dnsName, new byte[]{(byte)new Integer(matcher.group(1)).intValue(), (byte)new Integer(matcher.group(2)).intValue(), (byte)new Integer(matcher.group(3)).intValue(), (byte)new Integer(matcher.group(4)).intValue()}), -1L);
            curi.setFetchStatus(1);
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Should never be " + e.getMessage(), e);
            this.setUnresolvable(curi, targetHost);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordDNS(ProcessorURI curi, Record[] rrecordSet) throws IOException {
        byte[] dnsRecord = this.getDNSRecord(curi.getFetchBeginTime(), rrecordSet);
        Recorder rec = curi.getRecorder();
        boolean digestContent = (Boolean)curi.get(this, DIGEST_CONTENT);
        String algorithm = null;
        if (digestContent) {
            algorithm = (String)curi.get(this, DIGEST_ALGORITHM);
            rec.getRecordedInput().setDigest(algorithm);
        } else {
            rec.getRecordedInput().setDigest((MessageDigest)null);
        }
        InputStream is = curi.getRecorder().inputWrap((InputStream)new ByteArrayInputStream(dnsRecord));
        if (digestContent) {
            rec.getRecordedInput().startDigest();
        }
        try {
            while (is.read(this.reusableBuffer) != -1) {
            }
        }
        finally {
            is.close();
            rec.closeRecorders();
        }
        curi.setContentSize(dnsRecord.length);
        if (digestContent) {
            curi.setContentDigest(algorithm, rec.getRecordedInput().getDigestValue());
        }
    }

    protected byte[] getDNSRecord(long fetchStart, Record[] rrecordSet) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] fetchDate = ArchiveUtils.get14DigitDate((long)fetchStart).getBytes();
        baos.write(fetchDate);
        baos.write("\n".getBytes());
        int recordLength = fetchDate.length + 1;
        if (rrecordSet != null) {
            for (int i = 0; i < rrecordSet.length; ++i) {
                byte[] record = rrecordSet[i].toString().getBytes();
                recordLength += record.length;
                baos.write(record);
                baos.write("\n".getBytes());
                ++recordLength;
            }
        }
        return baos.toByteArray();
    }

    protected void setUnresolvable(ProcessorURI curi, CrawlHost host) {
        host.setIP(null, 0L);
        curi.setFetchStatus(-1);
    }

    protected ARecord getFirstARecord(Record[] rrecordSet) {
        ARecord arecord = null;
        if (rrecordSet == null || rrecordSet.length == 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("rrecordSet is null or zero length: " + rrecordSet);
            }
            return arecord;
        }
        for (int i = 0; i < rrecordSet.length; ++i) {
            if (rrecordSet[i].getType() != 1) {
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("Record " + Integer.toString(i) + " is not A type but " + rrecordSet[i].getType());
                continue;
            }
            arecord = (ARecord)rrecordSet[i];
            break;
        }
        return arecord;
    }

    static {
        KeyManager.addKeys(FetchDNS.class);
    }
}

