/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URIException;
import org.archive.io.RecordingInputStream;
import org.archive.io.ReplayCharSequence;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.Link;
import org.archive.modules.extractor.LinkContext;
import org.archive.net.ClientFTP;
import org.archive.net.FTPException;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.util.ArchiveUtils;
import org.archive.util.Recorder;

public class FetchFTP
extends Processor {
    private static final long serialVersionUID = ArchiveUtils.classnameBasedUID(FetchFTP.class, (int)1);
    private static Logger logger = Logger.getLogger(FetchFTP.class.getName());
    private static Pattern DIR = Pattern.compile("(.+)$", 8);
    public static final Key<String> USERNAME = Key.make((String)"anonymous");
    public static final Key<String> PASSWORD = Key.make((String)"password");
    public static final Key<Boolean> EXTRACT_FROM_DIRS = Key.make((boolean)true);
    public static final Key<Boolean> EXTRACT_PARENT = Key.make((boolean)true);
    public static final Key<Long> MAX_LENGTH_BYTES = Key.make((long)0L);
    public static final Key<Integer> FETCH_BANDWIDTH = Key.make((int)0);
    public static final Key<Integer> TIMEOUT_SECONDS = Key.make((int)1200);

    protected boolean shouldProcess(ProcessorURI curi) {
        return curi.getUURI().getScheme().equals("ftp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerProcess(ProcessorURI curi) throws InterruptedException {
        curi.setFetchBeginTime(System.currentTimeMillis());
        Recorder recorder = curi.getRecorder();
        ClientFTP client = new ClientFTP();
        try {
            this.fetch(curi, client, recorder);
        }
        catch (FTPException e) {
            logger.log(Level.SEVERE, "FTP server reported problem.", e);
            curi.setFetchStatus(e.getReplyCode());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IO Error during FTP fetch.", e);
            curi.setFetchStatus(-3);
        }
        finally {
            FetchFTP.disconnect(client);
            curi.setContentSize(recorder.getRecordedInput().getSize());
            curi.setFetchCompletedTime(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetch(ProcessorURI curi, ClientFTP client, Recorder recorder) throws IOException, InterruptedException {
        UURI uuri = curi.getUURI();
        int port = uuri.getPort();
        if (port == -1) {
            port = 21;
        }
        client.connectStrict(uuri.getHost(), port);
        String[] auth = this.getAuth(curi);
        client.loginStrict(auth[0], auth[1]);
        boolean dir = client.changeWorkingDirectory(uuri.getPath());
        if (dir) {
            curi.setContentType("text/plain");
        }
        if (logger.isLoggable(Level.FINE)) {
            String system = client.getSystemName();
            logger.fine(system);
        }
        int command = dir ? 27 : 13;
        String path = dir ? "." : uuri.getPath();
        client.enterLocalPassiveMode();
        client.setBinary();
        Socket socket = client.openDataConnection(command, path);
        curi.setFetchStatus(client.getReplyCode());
        try {
            this.saveToRecorder(curi, socket, recorder);
        }
        finally {
            recorder.close();
            FetchFTP.close(socket);
        }
        curi.setFetchStatus(200);
        if (dir) {
            this.extract(curi, recorder);
        }
        this.addParent(curi);
    }

    private void saveToRecorder(ProcessorURI curi, Socket socket, Recorder recorder) throws IOException, InterruptedException {
        recorder.markContentBegin();
        recorder.inputWrap(socket.getInputStream());
        recorder.outputWrap(socket.getOutputStream());
        long softMax = 0L;
        long hardMax = this.getMaxLength(curi);
        long timeout = (long)this.getTimeout(curi) * 1000L;
        int maxRate = this.getFetchBandwidth(curi);
        RecordingInputStream input = recorder.getRecordedInput();
        input.setLimits(hardMax, timeout, (long)maxRate);
        input.readFullyOrUntil(softMax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(ProcessorURI curi, Recorder recorder) {
        if (!this.getExtractFromDirs(curi)) {
            return;
        }
        ReplayCharSequence seq = null;
        try {
            seq = recorder.getReplayCharSequence();
            this.extract(curi, seq);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IO error during extraction.", e);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "IO error during extraction.", e);
        }
        finally {
            FetchFTP.close(seq);
        }
    }

    private void extract(ProcessorURI curi, ReplayCharSequence dir) {
        logger.log(Level.FINEST, "Extracting URIs from FTP directory.");
        Matcher matcher = DIR.matcher((CharSequence)dir);
        while (matcher.find()) {
            String file = matcher.group(1);
            this.addExtracted(curi, file);
        }
    }

    private void addExtracted(ProcessorURI curi, String file) {
        String base;
        try {
            file = URLEncoder.encode(file, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Found " + file);
        }
        if ((base = curi.toString()).endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        try {
            UURI n = UURIFactory.getInstance((String)(base + "/" + file));
            Link link = new Link((CharSequence)curi.getUURI(), (CharSequence)n, LinkContext.NAVLINK_MISC, Hop.NAVLINK);
            curi.getOutLinks().add(link);
        }
        catch (URIException e) {
            logger.log(Level.WARNING, "URI error during extraction.", e);
        }
    }

    private void addParent(ProcessorURI curi) {
        if (!this.getExtractParent(curi)) {
            return;
        }
        UURI uuri = curi.getUURI();
        try {
            if (uuri.getPath().equals("/")) {
                return;
            }
            String scheme = uuri.getScheme();
            String auth = uuri.getEscapedAuthority();
            String path = uuri.getEscapedCurrentHierPath();
            UURI parent = UURIFactory.getInstance((String)(scheme + "://" + auth + path));
            Link link = new Link((CharSequence)uuri, (CharSequence)parent, LinkContext.NAVLINK_MISC, Hop.NAVLINK);
            curi.getOutLinks().add(link);
        }
        catch (URIException e) {
            logger.log(Level.WARNING, "URI error during extraction.", e);
        }
    }

    public boolean getExtractFromDirs(ProcessorURI curi) {
        return (Boolean)curi.get(this, EXTRACT_FROM_DIRS);
    }

    public boolean getExtractParent(ProcessorURI curi) {
        return (Boolean)curi.get(this, EXTRACT_PARENT);
    }

    public int getTimeout(ProcessorURI curi) {
        return (Integer)curi.get(this, TIMEOUT_SECONDS);
    }

    public long getMaxLength(ProcessorURI curi) {
        return (Long)curi.get(this, MAX_LENGTH_BYTES);
    }

    public int getFetchBandwidth(ProcessorURI curi) {
        return (Integer)curi.get(this, FETCH_BANDWIDTH);
    }

    private String[] getAuth(ProcessorURI curi) {
        int p;
        String userinfo;
        String[] result = new String[2];
        UURI uuri = curi.getUURI();
        try {
            userinfo = uuri.getUserinfo();
        }
        catch (URIException e) {
            assert (false);
            logger.finest("getUserinfo raised URIException.");
            userinfo = null;
        }
        if (userinfo != null && (p = userinfo.indexOf(58)) > 0) {
            result[0] = userinfo.substring(0, p);
            result[1] = userinfo.substring(p + 1);
            return result;
        }
        result[0] = (String)curi.get(this, USERNAME);
        result[1] = (String)curi.get(this, PASSWORD);
        return result;
    }

    private static void close(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IO error closing socket.", e);
        }
    }

    private static void close(ReplayCharSequence seq) {
        if (seq == null) {
            return;
        }
        try {
            seq.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IO error closing ReplayCharSequence.", e);
        }
    }

    private static void disconnect(ClientFTP client) {
        block3: {
            if (client.isConnected()) {
                try {
                    client.disconnect();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    logger.warning("Could not disconnect from FTP client: " + e.getMessage());
                }
            }
        }
    }

    static {
        KeyManager.addKeys(FetchFTP.class);
    }
}

