/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.BasicScheme;
import org.apache.commons.httpclient.auth.DigestScheme;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.archive.httpclient.ConfigurableX509TrustManager;
import org.archive.httpclient.HttpRecorderGetMethod;
import org.archive.httpclient.HttpRecorderMethod;
import org.archive.httpclient.HttpRecorderPostMethod;
import org.archive.httpclient.SingleHttpConnectionManager;
import org.archive.io.RecorderLengthExceededException;
import org.archive.io.RecorderTimeoutException;
import org.archive.io.RecorderTooMuchHeaderException;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.modules.credential.Credential;
import org.archive.modules.credential.CredentialAvatar;
import org.archive.modules.credential.CredentialStore;
import org.archive.modules.credential.Rfc2617Credential;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRuleSequence;
import org.archive.modules.fetcher.BdbCookieStorage;
import org.archive.modules.fetcher.CookieStorage;
import org.archive.modules.fetcher.HeritrixHttpMethodRetryHandler;
import org.archive.modules.fetcher.HeritrixProtocolSocketFactory;
import org.archive.modules.fetcher.HeritrixSSLProtocolSocketFactory;
import org.archive.modules.fetcher.UserAgentProvider;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.ServerCache;
import org.archive.net.UURI;
import org.archive.settings.Finishable;
import org.archive.state.Expert;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Nullable;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;
import org.archive.util.Recorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchHTTP
extends Processor
implements Initializable,
Finishable {
    private static final long serialVersionUID = ArchiveUtils.classnameBasedUID(FetchHTTP.class, (int)1);
    private static Logger logger = Logger.getLogger(FetchHTTP.class.getName());
    @Expert
    public static final Key<String> HTTP_PROXY_HOST = Key.make((String)"");
    @Expert
    public static final Key<Integer> HTTP_PROXY_PORT = Key.make((int)0);
    public static final Key<Integer> TIMEOUT_SECONDS = Key.make((int)1200);
    @Expert
    public static final Key<Integer> SOTIMEOUT_MS = Key.make((int)20000);
    public static final Key<Long> MAX_LENGTH_BYTES = Key.make((long)0L);
    public static final Key<List<String>> ACCEPT_HEADERS = Key.makeList(String.class);
    @Expert
    public static final Key<String> DEFAULT_ENCODING = Key.make((String)"ISO-8859-1");
    @Expert
    public static final Key<Boolean> DIGEST_CONTENT = Key.make((boolean)true);
    @Expert
    public static final Key<String> DIGEST_ALGORITHM = Key.make((String)"sha1");
    @Expert
    public static final Key<Integer> FETCH_BANDWIDTH = Key.make((int)0);
    public static final Key<UserAgentProvider> USER_AGENT_PROVIDER = Key.makeAuto(UserAgentProvider.class);
    @Immutable
    @Expert
    public static final Key<String> TRUST_LEVEL = Key.make((String)"open");
    public static final String SHA1 = "sha1";
    private transient HttpClient http = null;
    private int recoveryRetries = 0;
    public static final Key<DecideRuleSequence> MIDFETCH_RULES = Key.make(DecideRuleSequence.class, DecideRuleSequence.class);
    private static final String MIDFETCH_ABORT_LOG = "midFetchAbort";
    @Expert
    public static final Key<Boolean> SEND_CONNECTION_CLOSE = Key.make((boolean)true);
    private static final Header HEADER_SEND_CONNECTION_CLOSE = new Header("Connection", "close");
    @Expert
    public static final Key<Boolean> SEND_REFERER = Key.make((boolean)true);
    @Expert
    public static final Key<Boolean> SEND_RANGE = Key.make((boolean)false);
    @Expert
    public static final Key<Boolean> SEND_IF_MODIFIED_SINCE = Key.make((boolean)true);
    @Expert
    public static final Key<Boolean> SEND_IF_NONE_MATCH = Key.make((boolean)true);
    public static final String REFERER = "Referer";
    public static final String RANGE = "Range";
    public static final String RANGE_PREFIX = "bytes=0-";
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    @Immutable
    @Nullable
    public static final Key<CookieStorage> COOKIE_STORAGE = Key.make(CookieStorage.class, BdbCookieStorage.class);
    public static final Key<Boolean> IGNORE_COOKIES = Key.make((boolean)false);
    public static final Key<String> HTTP_BIND_ADDRESS = Key.make((String)"");
    @Immutable
    public static final Key<CredentialStore> CREDENTIAL_STORE = Key.makeAuto(CredentialStore.class);
    @Immutable
    public static final Key<ServerCache> SERVER_CACHE = Key.makeAuto(ServerCache.class);
    static final String SSL_FACTORY_KEY = "heritrix.ssl.factory";
    private transient SSLSocketFactory sslfactory = null;
    private String trustLevel;
    private CredentialStore credentialStore;
    private ServerCache serverCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void innerProcess(final ProcessorURI curi) throws InterruptedException {
        curi.setFetchBeginTime(System.currentTimeMillis());
        Recorder rec = curi.getRecorder();
        boolean digestContent = (Boolean)curi.get(this, DIGEST_CONTENT);
        String algorithm = null;
        if (digestContent) {
            algorithm = (String)curi.get(this, DIGEST_ALGORITHM);
            rec.getRecordedInput().setDigest(algorithm);
        } else {
            rec.getRecordedInput().setDigest((MessageDigest)null);
        }
        String curiString = curi.getUURI().toString();
        Object method = null;
        method = curi.getFetchType() == ProcessorURI.FetchType.HTTP_POST ? new HttpRecorderPostMethod(curiString, rec){

            protected void readResponseBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
                FetchHTTP.this.addResponseContent((HttpMethod)this, curi);
                if (FetchHTTP.this.checkMidfetchAbort(curi, this.httpRecorderMethod, conn)) {
                    FetchHTTP.this.doAbort(curi, (HttpMethod)this, FetchHTTP.MIDFETCH_ABORT_LOG);
                } else {
                    super.readResponseBody(state, conn);
                }
            }
        } : new HttpRecorderGetMethod(curiString, rec){

            protected void readResponseBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
                FetchHTTP.this.addResponseContent((HttpMethod)this, curi);
                if (FetchHTTP.this.checkMidfetchAbort(curi, this.httpRecorderMethod, conn)) {
                    FetchHTTP.this.doAbort(curi, (HttpMethod)this, FetchHTTP.MIDFETCH_ABORT_LOG);
                } else {
                    super.readResponseBody(state, conn);
                }
            }
        };
        HostConfiguration customConfigOrNull = this.configureMethod(curi, (HttpMethod)method);
        boolean addedCredentials = this.populateCredentials(curi, (HttpMethod)method);
        method.setDoAuthentication(addedCredentials);
        long hardMax = this.getMaxLength(curi);
        long timeoutMs = 1000 * this.getTimeout(curi);
        long maxRateKBps = this.getMaxFetchRate(curi);
        rec.getRecordedInput().setLimits(hardMax, timeoutMs, maxRateKBps);
        try {
            this.http.executeMethod(customConfigOrNull, (HttpMethod)method);
        }
        catch (RecorderTooMuchHeaderException ex) {
            this.doAbort(curi, (HttpMethod)method, "headerTrunc");
        }
        catch (IOException e) {
            this.failedExecuteCleanup((HttpMethod)method, curi, e);
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.failedExecuteCleanup((HttpMethod)method, curi, e);
            return;
        }
        long softMax = method.getResponseContentLength();
        try {
            if (!method.isAborted()) {
                rec.getRecordedInput().readFullyOrUntil(softMax);
            }
        }
        catch (RecorderTimeoutException ex) {
            this.doAbort(curi, (HttpMethod)method, "timeTrunc");
        }
        catch (RecorderLengthExceededException ex) {
            this.doAbort(curi, (HttpMethod)method, "lenTrunc");
        }
        catch (IOException e) {
            this.cleanup(curi, e, "readFully", -3);
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.cleanup(curi, e, "readFully", -3);
            return;
        }
        finally {
            rec.closeRecorders();
            if (!method.isAborted()) {
                method.releaseConnection();
            }
            curi.setFetchCompletedTime(System.currentTimeMillis());
            this.setCharacterEncoding(curi, rec, (HttpMethod)method);
            this.setSizes(curi, rec);
        }
        if (digestContent) {
            curi.setContentDigest(algorithm, rec.getRecordedInput().getDigestValue());
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info((curi.getFetchType() == ProcessorURI.FetchType.HTTP_POST ? "POST" : "GET") + " " + curi.getUURI().toString() + " " + method.getStatusCode() + " " + rec.getRecordedInput().getSize() + " " + curi.getContentType());
        }
        if (FetchHTTP.isSuccess(curi) && addedCredentials) {
            Header setCookie;
            this.promoteCredentials(curi);
            if (logger.isLoggable(Level.FINE) && (setCookie = method.getResponseHeader("set-cookie")) != null) {
                logger.fine(setCookie.toString().trim());
            }
        } else if (method.getStatusCode() == 401) {
            this.handle401((HttpMethod)method, curi);
        }
        if (rec.getRecordedInput().isOpen()) {
            logger.severe(curi.toString() + " RIS still open. Should have" + " been closed by method release: " + Thread.currentThread().getName());
            try {
                rec.getRecordedInput().close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "second-chance RIS close failed", e);
            }
        }
    }

    protected void setSizes(ProcessorURI curi, Recorder rec) {
        Map[] history;
        curi.setContentSize(rec.getRecordedInput().getSize());
        if (curi.getFetchStatus() == 304 && curi.containsDataKey("fetch-history") && (history = (Map[])curi.getData().get("fetch-history"))[0] != null && history[0].containsKey("reference-length")) {
            long referenceLength = (Long)history[0].get("reference-length");
            curi.getData().put("reference-length", referenceLength);
            curi.setContentSize(rec.getRecordedInput().getSize() + referenceLength);
        }
    }

    protected void doAbort(ProcessorURI curi, HttpMethod method, String annotation) {
        curi.getAnnotations().add(annotation);
        curi.getRecorder().close();
        method.abort();
    }

    protected boolean checkMidfetchAbort(ProcessorURI curi, HttpRecorderMethod method, HttpConnection conn) {
        if (curi.isPrerequisite()) {
            return false;
        }
        DecideRuleSequence seq = (DecideRuleSequence)curi.get(this, MIDFETCH_RULES);
        DecideResult r = seq.decisionFor(curi);
        if (r != DecideResult.REJECT) {
            return false;
        }
        method.markContentBegin(conn);
        return true;
    }

    protected void addResponseContent(HttpMethod method, ProcessorURI curi) {
        curi.setFetchStatus(method.getStatusCode());
        Header ct = method.getResponseHeader("content-type");
        curi.setContentType(ct == null ? null : ct.getValue());
        curi.setHttpMethod(method);
    }

    private void setCharacterEncoding(ProcessorURI uri, Recorder rec, HttpMethod method) {
        String encoding = null;
        try {
            encoding = ((HttpMethodBase)method).getResponseCharSet();
            if (encoding == null || encoding.equals(DEFAULT_ENCODING.getDefaultValue())) {
                encoding = (String)uri.get(this, DEFAULT_ENCODING);
            }
        }
        catch (Exception e) {
            logger.warning("Failed get default encoding: " + e.getLocalizedMessage());
        }
        rec.setCharacterEncoding(encoding);
    }

    private void failedExecuteCleanup(HttpMethod method, ProcessorURI curi, Exception exception) {
        this.cleanup(curi, exception, "executeMethod", -2);
        method.releaseConnection();
    }

    private void cleanup(ProcessorURI curi, Exception exception, String message, int status) {
        curi.getNonFatalFailures().add(exception);
        curi.setFetchStatus(status);
        curi.getRecorder().close();
    }

    @Override
    public ProcessResult process(ProcessorURI uri) throws InterruptedException {
        if (uri.getFetchStatus() < 0) {
            return ProcessResult.FINISH;
        }
        return super.process(uri);
    }

    @Override
    protected boolean shouldProcess(ProcessorURI curi) {
        String scheme = curi.getUURI().getScheme();
        if (!scheme.equals(HTTP_SCHEME) && !scheme.equals(HTTPS_SCHEME)) {
            return false;
        }
        CrawlHost host = this.getHostFor(curi.getUURI());
        if (host.getIP() == null && host.hasBeenLookedUp()) {
            curi.setFetchStatus(-6);
            return false;
        }
        return true;
    }

    protected HostConfiguration configureMethod(ProcessorURI curi, HttpMethod method) {
        String via;
        method.setFollowRedirects(false);
        boolean ignoreCookies = (Boolean)curi.get(this, IGNORE_COOKIES);
        method.getParams().setCookiePolicy(ignoreCookies ? "ignoreCookies" : "compatibility");
        method.getParams().setVersion(HttpVersion.HTTP_1_0);
        UserAgentProvider uap = (UserAgentProvider)curi.get(this, USER_AGENT_PROVIDER);
        String from = uap.getFrom(curi);
        String userAgent = curi.getUserAgent();
        if (userAgent == null) {
            userAgent = uap.getUserAgent(curi);
        }
        method.setRequestHeader("User-Agent", userAgent);
        if (StringUtils.isNotBlank((String)from)) {
            method.setRequestHeader("From", from);
        }
        method.getParams().setParameter("http.method.retry-handler", (Object)new HeritrixHttpMethodRetryHandler());
        long maxLength = this.getMaxLength(curi);
        if (maxLength > 0L && ((Boolean)curi.get(this, SEND_RANGE)).booleanValue()) {
            method.addRequestHeader(RANGE, RANGE_PREFIX.concat(Long.toString(maxLength - 1L)));
        }
        if (((Boolean)curi.get(this, SEND_CONNECTION_CLOSE)).booleanValue()) {
            method.addRequestHeader(HEADER_SEND_CONNECTION_CLOSE);
        }
        if (!(!((Boolean)curi.get(this, SEND_REFERER)).booleanValue() || (via = FetchHTTP.flattenVia(curi)) == null || via.length() <= 0 || via.startsWith(HTTPS_SCHEME) && curi.getUURI().getScheme().equals(HTTP_SCHEME))) {
            method.setRequestHeader(REFERER, via);
        }
        if (!curi.isPrerequisite()) {
            this.setConditionalGetHeader(curi, method, SEND_IF_MODIFIED_SINCE, "last-modified", "If-Modified-Since");
            this.setConditionalGetHeader(curi, method, SEND_IF_NONE_MATCH, "etag", "If-None-Match");
        }
        this.setAcceptHeaders(curi, method);
        HostConfiguration config = new HostConfiguration(this.http.getHostConfiguration());
        this.configureProxy(curi, config);
        this.configureBindAddress(curi, config);
        return config;
    }

    protected void setConditionalGetHeader(ProcessorURI curi, HttpMethod method, Key<Boolean> setting, String sourceHeader, String targetHeader) {
        if (((Boolean)curi.get(this, setting)).booleanValue()) {
            try {
                Map[] history = (Map[])curi.getData().get("fetch-history");
                int previousStatus = (Integer)history[0].get("status");
                if (previousStatus <= 0) {
                    return;
                }
                String previousValue = (String)history[0].get(sourceHeader);
                if (previousValue != null) {
                    method.setRequestHeader(targetHeader, previousValue);
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
    }

    private void configureProxy(StateProvider curi, HostConfiguration config) {
        String proxy = (String)this.getAttributeEither(curi, HTTP_PROXY_HOST);
        int port = (Integer)this.getAttributeEither(curi, HTTP_PROXY_PORT);
        this.configureProxy(proxy, port, config);
    }

    private void configureProxy(String proxy, int port, HostConfiguration config) {
        if (StringUtils.isNotEmpty((String)proxy)) {
            config.setProxy(proxy, port);
        }
    }

    private void configureBindAddress(StateProvider curi, HostConfiguration config) {
        String addressString = (String)this.getAttributeEither(curi, HTTP_BIND_ADDRESS);
        this.configureBindAddress(addressString, config);
    }

    private void configureBindAddress(String address, HostConfiguration config) {
        if (StringUtils.isNotEmpty((String)address)) {
            try {
                InetAddress localAddress = InetAddress.getByName(address);
                config.setLocalAddress(localAddress);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Unknown host " + address + " in local-address");
            }
        }
    }

    protected Object getAttributeEither(StateProvider provider, Key<?> key) {
        ProcessorURI curi;
        Object r;
        if (provider instanceof ProcessorURI && (r = (curi = (ProcessorURI)provider).getData().get(key.getFieldName())) != null) {
            return r;
        }
        return provider.get((Object)this, key);
    }

    private boolean populateCredentials(ProcessorURI curi, HttpMethod method) {
        String serverKey;
        try {
            serverKey = CrawlServer.getServerKey(curi.getUURI());
        }
        catch (URIException e) {
            return false;
        }
        CrawlServer server = this.serverCache.getServerFor(serverKey);
        if (server.hasCredentialAvatars()) {
            for (CredentialAvatar ca : server.getCredentialAvatars()) {
                Credential c = ca.getCredential(this.credentialStore, curi);
                if (!c.isEveryTime()) continue;
                c.populate(curi, this.http, method, ca.getPayload());
            }
        }
        boolean result = false;
        for (CredentialAvatar ca : curi.getCredentialAvatars()) {
            Credential c = ca.getCredential(this.credentialStore, curi);
            if (!c.populate(curi, this.http, method, ca.getPayload())) continue;
            result = true;
        }
        return result;
    }

    private void promoteCredentials(ProcessorURI curi) {
        Set<CredentialAvatar> avatars = curi.getCredentialAvatars();
        Iterator<CredentialAvatar> i = avatars.iterator();
        while (i.hasNext()) {
            CrawlServer cs;
            CredentialAvatar ca = i.next();
            i.remove();
            Credential c = this.credentialStore.getCredential(curi, ca);
            String cd = c.getCredentialDomain(curi);
            if (cd == null || (cs = this.serverCache.getServerFor(cd)) == null) continue;
            cs.addCredentialAvatar(ca);
        }
    }

    protected void handle401(HttpMethod method, ProcessorURI curi) {
        AuthScheme authscheme = this.getAuthScheme(method, curi);
        if (authscheme == null) {
            return;
        }
        String realm = authscheme.getRealm();
        Set<Credential> curiRfc2617Credentials = this.getCredentials(curi, Rfc2617Credential.class);
        Rfc2617Credential extant = Rfc2617Credential.getByRealm(curiRfc2617Credentials, realm, curi);
        if (extant != null) {
            extant.detachAll(curi);
            logger.warning("Auth failed (401) though supplied realm " + realm + " to " + curi.toString());
        } else {
            String serverKey = FetchHTTP.getServerKey(curi);
            CrawlServer server = this.serverCache.getServerFor(serverKey);
            Set<Credential> storeRfc2617Credentials = this.credentialStore.subset(curi, Rfc2617Credential.class, server.getName());
            if (storeRfc2617Credentials == null || storeRfc2617Credentials.size() <= 0) {
                logger.info("No rfc2617 credentials for " + curi);
            } else {
                Rfc2617Credential found = Rfc2617Credential.getByRealm(storeRfc2617Credentials, realm, curi);
                if (found == null) {
                    logger.info("No rfc2617 credentials for realm " + realm + " in " + curi);
                } else {
                    found.attach(curi, authscheme.getRealm());
                    logger.info("Found credential for realm " + realm + " in store for " + curi.toString());
                }
            }
        }
    }

    protected AuthScheme getAuthScheme(HttpMethod method, ProcessorURI curi) {
        Header[] headers = method.getResponseHeaders("WWW-Authenticate");
        if (headers == null || headers.length <= 0) {
            logger.info("We got a 401 but no WWW-Authenticate challenge: " + curi.toString());
            return null;
        }
        Map authschemes = null;
        try {
            authschemes = AuthChallengeParser.parseChallenges((Header[])headers);
        }
        catch (MalformedChallengeException e) {
            logger.info("Failed challenge parse: " + e.getMessage());
        }
        if (authschemes == null || authschemes.size() <= 0) {
            logger.info("We got a 401 and WWW-Authenticate challenge but failed parse of the header " + curi.toString());
            return null;
        }
        BasicScheme result = null;
        Iterator i = authschemes.keySet().iterator();
        while (result == null && i.hasNext()) {
            String key = (String)i.next();
            String challenge = (String)authschemes.get(key);
            if (key == null || key.length() <= 0 || challenge == null || challenge.length() <= 0) {
                logger.warning("Empty scheme: " + curi.toString() + ": " + headers);
            }
            BasicScheme authscheme = null;
            if (key.equals("basic")) {
                authscheme = new BasicScheme();
            } else if (key.equals("digest")) {
                authscheme = new DigestScheme();
            } else {
                logger.info("Unsupported scheme: " + key);
                continue;
            }
            try {
                authscheme.processChallenge(challenge);
            }
            catch (MalformedChallengeException e) {
                logger.info(e.getMessage() + " " + curi + " " + headers);
                continue;
            }
            if (authscheme.isConnectionBased()) {
                logger.info("Connection based " + authscheme);
                continue;
            }
            if (authscheme.getRealm() == null || authscheme.getRealm().length() <= 0) {
                logger.info("Empty realm " + authscheme + " for " + curi);
                continue;
            }
            result = authscheme;
        }
        return result;
    }

    private Set<Credential> getCredentials(ProcessorURI curi, Class type) {
        HashSet<Credential> result = null;
        if (curi.hasCredentialAvatars()) {
            for (CredentialAvatar ca : curi.getCredentialAvatars()) {
                if (!ca.match(type)) continue;
                if (result == null) {
                    result = new HashSet<Credential>();
                }
                result.add(ca.getCredential(this.credentialStore, curi));
            }
        }
        return result;
    }

    public void initialTasks(StateProvider defaults) {
        this.serverCache = (ServerCache)defaults.get((Object)this, SERVER_CACHE);
        this.credentialStore = (CredentialStore)defaults.get((Object)this, CREDENTIAL_STORE);
        this.configureHttp(defaults);
        CookieStorage cm = (CookieStorage)defaults.get((Object)this, COOKIE_STORAGE);
        if (cm != null) {
            this.http.getState().setCookiesMap(cm.getCookiesMap());
        }
        this.trustLevel = (String)defaults.get((Object)this, TRUST_LEVEL);
        this.setSSLFactory();
    }

    private void setSSLFactory() {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new ConfigurableX509TrustManager(this.trustLevel)}, null);
            this.sslfactory = context.getSocketFactory();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed configure of ssl context " + e.getMessage(), e);
        }
    }

    public void finalTasks(StateProvider defaults) {
        CookieStorage cs = (CookieStorage)defaults.get((Object)this, COOKIE_STORAGE);
        if (cs != null) {
            SortedMap map = this.http.getState().getCookiesMap();
            cs.saveCookiesMap(map);
        }
        this.cleanupHttp();
    }

    protected void cleanupHttp() {
    }

    protected void configureHttp(StateProvider defaults) {
        int soTimeout = (Integer)defaults.get((Object)this, SOTIMEOUT_MS);
        String addressStr = (String)this.getAttributeEither(defaults, HTTP_BIND_ADDRESS);
        String proxy = (String)this.getAttributeEither(defaults, HTTP_PROXY_HOST);
        int port = -1;
        if (proxy.length() == 0) {
            proxy = null;
        } else {
            port = (Integer)this.getAttributeEither(defaults, HTTP_PROXY_PORT);
        }
        this.configureHttp(soTimeout, addressStr, proxy, port);
    }

    protected void configureHttp(int soTimeout, String addressStr, String proxy, int port) {
        int timeout = soTimeout > 0 ? soTimeout : 0;
        SingleHttpConnectionManager cm = new SingleHttpConnectionManager();
        HttpConnectionManagerParams hcmp = cm.getParams();
        hcmp.setConnectionTimeout(timeout);
        hcmp.setStaleCheckingEnabled(true);
        hcmp.setTcpNoDelay(false);
        this.http = new HttpClient((HttpConnectionManager)cm);
        HttpClientParams hcp = this.http.getParams();
        hcp.setSoTimeout(timeout);
        hcp.setVersion(HttpVersion.HTTP_1_0);
        this.http.getParams().setParameter("http.protocol.single-cookie-header", (Object)new Boolean(true));
        this.http.getParams().setParameter("http.protocol.unambiguous-statusline", (Object)new Boolean(false));
        this.http.getParams().setParameter("http.protocol.strict-transfer-encoding", (Object)new Boolean(false));
        this.http.getParams().setIntParameter("http.protocol.status-line-garbage-limit", 10);
        if (proxy != null && proxy.length() == 0) {
            proxy = null;
        }
        HostConfiguration config = this.http.getHostConfiguration();
        this.configureProxy(proxy, port, config);
        this.configureBindAddress(addressStr, config);
        hcmp.setParameter(SSL_FACTORY_KEY, (Object)this.sslfactory);
    }

    private int getTimeout(ProcessorURI curi) {
        return (Integer)curi.get(this, TIMEOUT_SECONDS);
    }

    private int getMaxFetchRate(ProcessorURI curi) {
        return (Integer)curi.get(this, FETCH_BANDWIDTH);
    }

    private long getMaxLength(ProcessorURI curi) {
        return (Long)curi.get(this, MAX_LENGTH_BYTES);
    }

    @Override
    public String report() {
        StringBuffer ret = new StringBuffer();
        ret.append("Processor: org.archive.crawler.fetcher.FetchHTTP\n");
        ret.append("  Function:          Fetch HTTP URIs\n");
        ret.append("  ProcessorURIs handled: " + this.getURICount() + "\n");
        ret.append("  Recovery retries:   " + this.recoveryRetries + "\n\n");
        return ret.toString();
    }

    private void setAcceptHeaders(ProcessorURI curi, HttpMethod get) {
        List acceptHeaders = (List)curi.get(this, ACCEPT_HEADERS);
        if (acceptHeaders.isEmpty()) {
            return;
        }
        for (String hdr : acceptHeaders) {
            String[] nvp = hdr.split(": +");
            if (nvp.length == 2) {
                get.setRequestHeader(nvp[0], nvp[1]);
                continue;
            }
            logger.warning("Invalid accept header: " + hdr);
        }
    }

    private String getLocalAddress() {
        HostConfiguration hc = this.http.getHostConfiguration();
        if (hc == null) {
            return "";
        }
        InetAddress addr = hc.getLocalAddress();
        if (addr == null) {
            return "";
        }
        String r = addr.getHostName();
        if (r == null) {
            return "";
        }
        return r;
    }

    private String getProxyHost() {
        HostConfiguration hc = this.http.getHostConfiguration();
        if (hc == null) {
            return "";
        }
        String r = hc.getProxyHost();
        if (r == null) {
            return "";
        }
        return r;
    }

    private int getProxyPort() {
        HostConfiguration hc = this.http.getHostConfiguration();
        if (hc == null) {
            return -1;
        }
        return hc.getProxyPort();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.http.getParams().getSoTimeout());
        stream.writeUTF(this.getLocalAddress());
        stream.writeUTF(this.getProxyHost());
        stream.writeInt(this.getProxyPort());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int soTimeout = stream.readInt();
        String localAddress = stream.readUTF();
        String proxy = stream.readUTF();
        int port = stream.readInt();
        this.configureHttp(soTimeout, localAddress, proxy, port);
        this.setSSLFactory();
    }

    protected HttpClient getHttp() {
        return this.http;
    }

    private static String getServerKey(ProcessorURI uri) {
        try {
            return CrawlServer.getServerKey(uri.getUURI());
        }
        catch (URIException e) {
            logger.severe(e.getMessage() + ": " + uri);
            e.printStackTrace();
            return null;
        }
    }

    private CrawlHost getHostFor(UURI uuri) {
        CrawlHost h = null;
        try {
            h = this.serverCache.getHostFor(uuri.getReferencedHost());
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        return h;
    }

    static {
        Protocol.registerProtocol((String)HTTP_SCHEME, (Protocol)new Protocol(HTTP_SCHEME, (ProtocolSocketFactory)new HeritrixProtocolSocketFactory(), 80));
        try {
            HeritrixSSLProtocolSocketFactory psf = new HeritrixSSLProtocolSocketFactory();
            Protocol p = new Protocol(HTTPS_SCHEME, (ProtocolSocketFactory)psf, 443);
            Protocol.registerProtocol((String)HTTPS_SCHEME, (Protocol)p);
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        KeyManager.addKeys(FetchHTTP.class);
    }
}

