/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.PrintWriter;
import java.io.Serializable;
import org.archive.modules.ProcessorURI;
import org.archive.modules.fetcher.FetchStatusCodes;
import org.archive.util.ArchiveUtils;
import org.archive.util.Reporter;

public class FetchStats
implements Serializable,
FetchStatusCodes,
Reporter {
    private static final long serialVersionUID = 8624425657056569036L;
    long totalScheduled;
    long fetchSuccesses;
    long fetchFailures;
    long fetchDisregards;
    long fetchResponses;
    long robotsDenials;
    long successBytes;
    long totalBytes;
    long fetchNonResponses;

    public synchronized void tally(ProcessorURI curi, Stage stage) {
        switch (stage) {
            case SCHEDULED: {
                ++this.totalScheduled;
                break;
            }
            case RETRIED: {
                if (curi.getFetchStatus() > 0) break;
                ++this.fetchNonResponses;
                return;
            }
            case SUCCEEDED: {
                ++this.fetchSuccesses;
                this.totalBytes += curi.getContentSize();
                this.successBytes += curi.getContentSize();
                break;
            }
            case DISREGARDED: {
                ++this.fetchDisregards;
                if (curi.getFetchStatus() != -9998) break;
                ++this.robotsDenials;
                break;
            }
            case FAILED: {
                if (curi.getFetchStatus() <= 0) {
                    ++this.fetchNonResponses;
                } else {
                    this.totalBytes += curi.getContentSize();
                }
                ++this.fetchFailures;
            }
        }
    }

    public long getFetchSuccesses() {
        return this.fetchSuccesses;
    }

    public long getFetchResponses() {
        return this.fetchResponses;
    }

    public long getSuccessBytes() {
        return this.successBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getFetchNonResponses() {
        return this.fetchNonResponses;
    }

    public long getTotalScheduled() {
        return this.totalScheduled;
    }

    public long getFetchDisregards() {
        return this.fetchDisregards;
    }

    public long getRobotsDenials() {
        return this.robotsDenials;
    }

    public long getRemaining() {
        return this.totalScheduled - (this.fetchSuccesses + this.fetchFailures + this.fetchDisregards);
    }

    public long getRecordedFinishes() {
        return this.fetchSuccesses + this.fetchFailures;
    }

    public String[] getReports() {
        return null;
    }

    public void reportTo(String name, PrintWriter writer) {
        writer.println(this.singleLineLegend());
        this.singleLineReportTo(writer);
    }

    public void reportTo(PrintWriter writer) {
        this.reportTo(null, writer);
    }

    public String singleLineLegend() {
        return "totalScheduled fetchSuccesses fetchFailures fetchDisregards fetchResponses robotsDenials successBytes totalBytes fetchNonResponses";
    }

    public String singleLineReport() {
        return ArchiveUtils.singleLineReport((Reporter)this);
    }

    public void singleLineReportTo(PrintWriter writer) {
        writer.print(this.totalScheduled);
        writer.print(" ");
        writer.print(this.fetchSuccesses);
        writer.print(" ");
        writer.print(this.fetchFailures);
        writer.print(" ");
        writer.print(this.fetchDisregards);
        writer.print(" ");
        writer.print(this.fetchResponses);
        writer.print(" ");
        writer.print(this.robotsDenials);
        writer.print(" ");
        writer.print(this.successBytes);
        writer.print(" ");
        writer.print(this.totalBytes);
        writer.print(" ");
        writer.print(this.fetchNonResponses);
    }

    public static interface CollectsFetchStats {
        public void tally(ProcessorURI var1, Stage var2);
    }

    public static interface HasFetchStats {
        public FetchStats getSubstats();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        SCHEDULED,
        RELOCATED,
        RETRIED,
        SUCCEEDED,
        DISREGARDED,
        FAILED;

    }
}

