/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.methods.PostMethod;

public class HeritrixHttpMethodRetryHandler
implements HttpMethodRetryHandler {
    private static final int DEFAULT_RETRY_COUNT = 10;
    private final int maxRetryCount;

    public HeritrixHttpMethodRetryHandler() {
        this(10);
    }

    public HeritrixHttpMethodRetryHandler(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
        if (exception instanceof SocketTimeoutException) {
            return false;
        }
        if (executionCount >= this.maxRetryCount) {
            return false;
        }
        if (exception instanceof NoHttpResponseException) {
            return true;
        }
        return !method.isRequestSent() && !(method instanceof PostMethod);
    }
}

