/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.archive.modules.fetcher.HostResolver;

public class HeritrixProtocolSocketFactory
implements ProtocolSocketFactory {
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return new Socket(host, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        Socket socket = null;
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            socket = this.createSocket(host, port, localAddress, localPort);
        } else {
            InetAddress hostAddress;
            socket = new Socket();
            Thread current = Thread.currentThread();
            if (current instanceof HostResolver) {
                HostResolver resolver = (HostResolver)((Object)current);
                hostAddress = resolver.resolve(host);
            } else {
                hostAddress = null;
            }
            InetSocketAddress address = hostAddress != null ? new InetSocketAddress(hostAddress, port) : new InetSocketAddress(host, port);
            socket.bind(new InetSocketAddress(localAddress, localPort));
            try {
                socket.connect(address, timeout);
            }
            catch (SocketTimeoutException e) {
                throw new SocketTimeoutException(e.getMessage() + ": timeout set at " + Integer.toString(timeout) + "ms.");
            }
            assert (socket.isConnected()) : "Socket not connected " + host;
        }
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return new Socket(host, port);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(HeritrixProtocolSocketFactory.class);
    }

    public int hashCode() {
        return HeritrixProtocolSocketFactory.class.hashCode();
    }
}

