/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.archive.httpclient.ConfigurableX509TrustManager;
import org.archive.modules.fetcher.HostResolver;

public class HeritrixSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private SSLSocketFactory sslDefaultFactory = null;

    public HeritrixSSLProtocolSocketFactory() throws KeyManagementException, KeyStoreException, NoSuchAlgorithmException {
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(null, new TrustManager[]{new ConfigurableX509TrustManager("open")}, null);
        this.sslDefaultFactory = context.getSocketFactory();
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.sslDefaultFactory.createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.sslDefaultFactory.createSocket(host, port);
    }

    public synchronized Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        Socket socket = null;
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            socket = this.createSocket(host, port, localAddress, localPort);
        } else {
            InetAddress hostAddress;
            SSLSocketFactory factory = (SSLSocketFactory)params.getParameter("heritrix.ssl.factory");
            SSLSocketFactory f = factory != null ? factory : this.sslDefaultFactory;
            socket = f.createSocket();
            Thread current = Thread.currentThread();
            if (current instanceof HostResolver) {
                HostResolver resolver = (HostResolver)((Object)current);
                hostAddress = resolver.resolve(host);
            } else {
                hostAddress = null;
            }
            InetSocketAddress address = hostAddress != null ? new InetSocketAddress(hostAddress, port) : new InetSocketAddress(host, port);
            socket.bind(new InetSocketAddress(localAddress, localPort));
            try {
                socket.connect(address, timeout);
            }
            catch (SocketTimeoutException e) {
                throw new SocketTimeoutException(e.getMessage() + ": timeout set at " + Integer.toString(timeout) + "ms.");
            }
            assert (socket.isConnected()) : "Socket not connected " + host;
        }
        return socket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.sslDefaultFactory.createSocket(socket, host, port, autoClose);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(HeritrixSSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return HeritrixSSLProtocolSocketFactory.class.hashCode();
    }
}

