/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.net;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.modules.fetcher.FetchStats;
import org.archive.util.InetAddressUtil;

public class CrawlHost
implements Serializable,
FetchStats.HasFetchStats {
    private static final long serialVersionUID = -5494573967890942895L;
    private static final Logger logger = Logger.getLogger(CrawlHost.class.getName());
    public static final long IP_NEVER_EXPIRES = -1L;
    public static final long IP_NEVER_LOOKED_UP = -2L;
    private String hostname;
    private String countryCode;
    private InetAddress ip;
    private long ipFetched = -2L;
    protected FetchStats substats = new FetchStats();
    private long ipTTL = -2L;
    private long earliestNextURIEmitTime = 0L;

    public CrawlHost(String hostname) {
        this(hostname, null);
    }

    public CrawlHost(String hostname, String countryCode) {
        this.hostname = hostname;
        this.countryCode = countryCode;
        InetAddress tmp = InetAddressUtil.getIPHostAddress((String)hostname);
        if (tmp != null) {
            this.setIP(tmp, -1L);
        }
    }

    public boolean hasBeenLookedUp() {
        return this.ipFetched != -2L;
    }

    public void setIP(InetAddress address, long ttl) {
        this.ip = address;
        this.ipFetched = System.currentTimeMillis();
        this.ipTTL = ttl;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.hostname + ": " + (address != null ? address.toString() : "null"));
        }
    }

    public InetAddress getIP() {
        return this.ip;
    }

    public long getIpFetched() {
        return this.ipFetched;
    }

    public long getIpTTL() {
        return this.ipTTL;
    }

    public String toString() {
        return "CrawlHost<" + this.hostname + "(ip:" + this.ip + ")>";
    }

    public String getHostName() {
        return this.hostname;
    }

    public long getEarliestNextURIEmitTime() {
        return this.earliestNextURIEmitTime;
    }

    public void setEarliestNextURIEmitTime(long earliestNextURIEmitTime) {
        this.earliestNextURIEmitTime = earliestNextURIEmitTime;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public FetchStats getSubstats() {
        return this.substats;
    }
}

