/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.Checksum;
import org.apache.commons.httpclient.URIException;
import org.archive.io.ReplayInputStream;
import org.archive.modules.ProcessorURI;
import org.archive.modules.credential.CredentialAvatar;
import org.archive.modules.fetcher.FetchStats;
import org.archive.modules.net.RobotsExclusionPolicy;
import org.archive.modules.net.RobotsHonoringPolicy;
import org.archive.net.UURI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawlServer
implements Serializable,
FetchStats.HasFetchStats {
    private static final long serialVersionUID = 3L;
    public static final long ROBOTS_NOT_FETCHED = -1L;
    public static final long MIN_ROBOTS_RETRIES = 2L;
    private final String server;
    private int port;
    private RobotsExclusionPolicy robots;
    long robotsFetched = -1L;
    boolean validRobots = false;
    Checksum robotstxtChecksum;
    FetchStats substats = new FetchStats();
    protected int consecutiveConnectionErrors = 0;
    private transient Set<CredentialAvatar> avatars = null;

    public CrawlServer(String h) {
        this.server = h;
        int colonIndex = this.server.lastIndexOf(":");
        if (colonIndex < 0) {
            this.port = -1;
        } else {
            try {
                this.port = Integer.parseInt(this.server.substring(colonIndex + 1));
            }
            catch (NumberFormatException e) {
                this.port = -1;
            }
        }
    }

    public RobotsExclusionPolicy getRobots() {
        return this.robots;
    }

    public void setRobots(RobotsExclusionPolicy policy) {
        this.robots = policy;
    }

    public String toString() {
        return "CrawlServer(" + this.server + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRobots(RobotsHonoringPolicy honoringPolicy, ProcessorURI curi) {
        boolean gotSomething;
        this.robotsFetched = System.currentTimeMillis();
        ProcessorURI.FetchType ft = curi.getFetchType();
        boolean bl = gotSomething = curi.getFetchStatus() > 0 && (ft == ProcessorURI.FetchType.HTTP_GET || ft == ProcessorURI.FetchType.HTTP_POST);
        if (!gotSomething && (long)curi.getFetchAttempts() < 2L) {
            this.validRobots = false;
            return;
        }
        RobotsHonoringPolicy.Type type = honoringPolicy.getType(curi);
        if (type == RobotsHonoringPolicy.Type.IGNORE) {
            this.robots = RobotsExclusionPolicy.ALLOWALL;
            this.validRobots = true;
            return;
        }
        if (!gotSomething) {
            this.validRobots = false;
            return;
        }
        int fetchStatus = curi.getFetchStatus();
        if (fetchStatus < 200 || fetchStatus >= 300) {
            this.robots = RobotsExclusionPolicy.ALLOWALL;
            this.validRobots = true;
            return;
        }
        ReplayInputStream contentBodyStream = null;
        try {
            try {
                BufferedReader reader;
                if (type == RobotsHonoringPolicy.Type.CUSTOM) {
                    reader = new BufferedReader(new StringReader(honoringPolicy.getCustomRobots(curi)));
                } else {
                    contentBodyStream = curi.getRecorder().getRecordedInput().getContentReplayInputStream();
                    contentBodyStream.setToResponseBodyStart();
                    reader = new BufferedReader(new InputStreamReader((InputStream)contentBodyStream));
                }
                this.robots = RobotsExclusionPolicy.policyFor(curi, reader, honoringPolicy);
                this.validRobots = true;
            }
            finally {
                if (contentBodyStream != null) {
                    contentBodyStream.close();
                }
            }
        }
        catch (IOException e) {
            this.robots = RobotsExclusionPolicy.ALLOWALL;
            this.validRobots = true;
            curi.getNonFatalFailures().add(e);
        }
    }

    public long getRobotsFetchedTime() {
        return this.robotsFetched;
    }

    public String getName() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public void incrementConsecutiveConnectionErrors() {
        ++this.consecutiveConnectionErrors;
    }

    public void resetConsecutiveConnectionErrors() {
        this.consecutiveConnectionErrors = 0;
    }

    public Set<CredentialAvatar> getCredentialAvatars() {
        return this.avatars;
    }

    public boolean hasCredentialAvatars() {
        return this.avatars != null && this.avatars.size() > 0;
    }

    public void addCredentialAvatar(CredentialAvatar ca) {
        if (this.avatars == null) {
            this.avatars = new HashSet<CredentialAvatar>();
        }
        this.avatars.add(ca);
    }

    public boolean isValidRobots() {
        return this.validRobots;
    }

    public static String getServerKey(UURI uuri) throws URIException {
        String key = uuri.getAuthorityMinusUserinfo();
        if (key == null && (key = uuri.getCurrentHierPath()) != null && !key.matches("[-_\\w\\.:]+")) {
            key = null;
        }
        if (key != null && uuri.getScheme().equals("https") && !key.matches(".+:[0-9]+")) {
            key = key + ":443";
        }
        return key;
    }

    @Override
    public FetchStats getSubstats() {
        return this.substats;
    }
}

